# clinical codes that indicate ETHUD - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate ETHUD**

## ValueSet: clinical codes that indicate ETHUD 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETHUD | *Version*:0.1.0 |
| Active as of 2016-09-09 | *Computable Name*:SamhsaSensitiveETHUD |
| **Usage:**Clinical Focus: alcohol use disorder information sensitivity | |

 
codes that when found in data would indicate the data is likely ETHUD related 
ETHUD - alcohol abuse information sensitivity (alcohol abuse information) 
* **SAMHSA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMHSA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SamhsaSensitiveETHUD",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETHUD",
  "version" : "0.1.0",
  "name" : "SamhsaSensitiveETHUD",
  "title" : "clinical codes that indicate ETHUD",
  "status" : "active",
  "experimental" : false,
  "date" : "2016-09-09",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "codes that when found in data would indicate the data is likely ETHUD related\n\nETHUD - alcohol abuse information sensitivity (alcohol abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "ETHUD"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.1"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.2"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.3"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.4"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.5"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.65"
        ]
      }
    ]
  }
}

```
