# clinical codes that indicate ETH - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate ETH**

## ValueSet: clinical codes that indicate ETH 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETH | *Version*:0.1.0 |
| Active as of 2016-09-09 | *Computable Name*:SamhsaSensitiveETH |
| **Usage:**Clinical Focus: substance abuse information sensitivity | |

 
codes that when found in data would indicate the data is likely ETH related 
ETH - substance abuse information sensitivity (alcohol or drug-abuse information) 
* **SAMHSA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMHSA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMHSA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMHSA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMHSA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMHSA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMHSA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMHSA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMHSA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
* **SAMHSA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SamhsaSensitiveETH",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETH",
  "version" : "0.1.0",
  "name" : "SamhsaSensitiveETH",
  "title" : "clinical codes that indicate ETH",
  "status" : "active",
  "experimental" : false,
  "date" : "2016-09-09",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "codes that when found in data would indicate the data is likely ETH related\n\nETH - substance abuse information sensitivity (alcohol or drug-abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA C2S Amphetamine Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC\n* **SAMHSA C2S Cannabis Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT\n* **SAMHSA C2S Cocaine Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT\n* **SAMHSA C2S Hallucinogens**\n  * ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT\n* **SAMHSA C2S Inhalants**\n  * ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT\n* **SAMHSA C2S Opioids**\n  * ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT\n* **SAMHSA C2S Other Psychoactive Substance Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM\n* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM\n* **SAMHSA C2S Substance use Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "ETH"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.1"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.2"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.3"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.4"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.5"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.10"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.11"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.6"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.7"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.8"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.9"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.12"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.13"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.14"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.15"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.16"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.17"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.18"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.19"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.20"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.21"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.22"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.28"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.29"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.30"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.38"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.39"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.40"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.41"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.42"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.59"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.43"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.44"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.45"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.46"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.47"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.48"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.55"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.56"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.57"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.65"
        ]
      }
    ]
  }
}

```
