# ValueSet - Leap SLS Sexuality and Reproductive Health Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Leap SLS Sexuality and Reproductive Health Codes**

## ValueSet: ValueSet - Leap SLS Sexuality and Reproductive Health Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSexualityAndReproductiveHealthCodes | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:LeapSlsSexualityAndReproductiveHealthCodes |
| **Usage:**Clinical Focus: sexuality and reproductive health information sensitivity | |

 
Leap SLS set of codes representing sexuality and reproductive health requiring special privacy protections 
Identified as: v3-ActCode#SEX 

 **References** 

* Included into [LeapSlsSensitiveCodes](ValueSet-LeapSlsSensitiveCodes.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "LeapSlsSexualityAndReproductiveHealthCodes",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSexualityAndReproductiveHealthCodes",
  "version" : "0.1.0",
  "name" : "LeapSlsSexualityAndReproductiveHealthCodes",
  "title" : "ValueSet - Leap SLS Sexuality and Reproductive Health Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Leap SLS set of codes representing sexuality and reproductive health requiring special privacy protections\n\nIdentified as: v3-ActCode#SEX",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SEX"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "72892002"
          }
        ]
      }
    ]
  }
}

```
