# ValueSet - Leap SLS Opioid Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Leap SLS Opioid Codes**

## ValueSet: ValueSet - Leap SLS Opioid Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:LeapSlsOpioidCodes |
| **Usage:**Clinical Focus: opioid use disorder information sensitivity, Clinical Focus: substance use disorder information sensitivity, Clinical Focus: 42 CFR Part2 | |

 
Leap SLS set of codes representing opioid abuse requiring special privacy protections. 
Identified as: v3-ActCode#OPIOIDUD 

 **References** 

* Included into [LeapSlsSensitiveCodes](ValueSet-LeapSlsSensitiveCodes.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "LeapSlsOpioidCodes",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes",
  "version" : "0.1.0",
  "name" : "LeapSlsOpioidCodes",
  "title" : "ValueSet - Leap SLS Opioid Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Leap SLS set of codes representing opioid abuse requiring special privacy protections.\n\nIdentified as: v3-ActCode#OPIOIDUD",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "OPIOIDUD"
          }
        ]
      }
    },
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SUD"
          }
        ]
      }
    },
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "42CFRPart2"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "425741009"
          },
          {
            "code" : "5602001"
          },
          {
            "code" : "145121000119106"
          },
          {
            "code" : "1149222004"
          },
          {
            "code" : "56876005"
          },
          {
            "code" : "60112009"
          },
          {
            "code" : "61480009"
          },
          {
            "code" : "266707007"
          },
          {
            "code" : "52052004"
          },
          {
            "code" : "6525002"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "352364"
          },
          {
            "code" : "1049221"
          },
          {
            "code" : "856987"
          },
          {
            "code" : "1860154"
          }
        ]
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "concept" : [
          {
            "code" : "F11.11"
          },
          {
            "code" : "F11.1"
          }
        ]
      }
    ]
  }
}

```
