/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.builtin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.builtin.SimpleReturnFunction;
import net.sourceforge.plantuml.tim.expression.TValue;

public class JsonRemove
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%json_remove", 2);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        TValue data = values.get(0);
        if (!data.isJson()) {
            throw new EaterException("Not JSON data", location);
        }
        JsonValue json = data.toJson().cloneMe();
        if (!json.isArray() && !json.isObject()) {
            return data;
        }
        if (json.isArray()) {
            Integer index;
            if (values.get(1).isNumber() && 0 <= (index = Integer.valueOf(values.get(1).toInt())) && index < json.asArray().size()) {
                json.asArray().remove(index);
            }
            return TValue.fromJson(json);
        }
        if (json.isObject()) {
            String name = values.get(1).toString();
            json.asObject().remove(name);
            return TValue.fromJson(json);
        }
        throw new EaterException("Bad JSON type", location);
    }
}

