# Zorgnetwerk - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**RAO**](0rao.md)
* **Zorgnetwerk**

## Zorgnetwerk

**Dit is een RIVO Architectuur Overleg onderwerp.**

### Inzage zorgnetwerk

Inzage in het zorgnetwerk van een patiënt/cliënt binnen het zorgdomein.

### Fasering

1. Doordat de arts in de informatie kijkt in de Zorgviewer
1. Overzicht afleiden en presenteren uit beschikbare informatie Zorgviewer
1. Eventueel lookup contact gegevens van de zorgverleners als voldoende sleutelvelden beschikbaar

1. Zorgteam bijhouden bijvoorbeeld irt Behandelplan

#### Afleiden uit beschikbare informatie

In onderstaande tabel staat een overzicht van gegevens die mogelijk het zorgnetwerk voor een patient vormen. Zowel de bron in de zib als de bron in FHIR, waar soms meer in staat dan in de zib. De laatste 5 kolommen (Zorgviewer, Epic, Zorgplatform, Nexus, Sanday) geeft per systeem aan of dat gegeven via FHIR beschikbaar is (Persoon, Zorginstelling, Contactdatums). De 3 legenda waarden gaan over beschikbaarheid van de gegevens. '111' betekent dat het gegeven in de kolom Persoon, Zorginstellen als Contactdatums beschikbaar is.

* Zib (FHIR Resource): Patient (Patient)
  * Persoon: 
  * Zorginstelling: 
  * Contactdatums: 
  * Zorgviewer: 1--
  * Epic: 1--
  * Zorgplatform: 1--
  * Nexus: 1--
* Zib (FHIR Resource): Relaties niet in Patient zib
  * Persoon: Huisarts / Patient.generalPractitioner (Pract)
  * Zorginstelling: Houder van het dossier / Patient.managingOrganization (Org) 
  * Contactdatums: nvt
  * Zorgviewer: 00-
  * Epic: 11-
  * Zorgplatform: 11-
  * Nexus: 11-
* Zib (FHIR Resource): ContactPersoon (Patient.contact)
  * Persoon: e.g. wife / Patient.contact
  * Zorginstelling: nvt
  * Contactdatums: nvt
  * Zorgviewer: 0--
  * Epic: 1--
  * Zorgplatform: 1--
  * Nexus: 1--
* Zib (FHIR Resource): Problemen (Condition)
  * Persoon: Diagnosesteller  Condition.asserter (Practitioner) 
  * Zorginstelling: 
  * Contactdatums: Diagnosestelling  Condition.assertedDate 
  * Zorgviewer: 0-0
  * Epic: 0-1
  * Zorgplatform: 1-1
  * Nexus: 0-0
* Zib (FHIR Resource): Verrichtingen (Procedure)
  * Persoon: Procedure.performer (Practitioner)
  * Zorginstelling: Procedure.performer (Location)  (N.B. Epic/ZP use Performer.location) 
  * Contactdatums: Procedure.performedDateTime
  * Zorgviewer: 111
  * Epic: 111
  * Zorgplatform: 111
  * Nexus: 111
* Zib (FHIR Resource): VG Verrichtingen (Procedure) - vaak niet gecodeerd
  * Persoon: Procedure.performer (Practitioner)
  * Zorginstelling: Procedure.performer (Location)
  * Contactdatums: Procedure.performedDateTime
  * Zorgviewer: 111
  * Epic: 001
  * Zorgplatform: ???
  * Nexus: ???
* Zib (FHIR Resource): Contact (Encounter)
  * Persoon: Met  Encounter.participant.individual (Practitioner) 
  * Zorginstelling: Locatie  Encounter.serviceProvider (Organization)  (Epic uses Encounter.location)  UMCG heeft ook nog afdeling als 2de locatie! 
  * Contactdatums: Encounter.period
  * Zorgviewer: 000
  * Epic: 111
  * Zorgplatform: 111
  * Nexus: 111
* Zib (FHIR Resource): Medicatieafspraak (MedicationRequest)
  * Persoon: Voorschrijver MedicationRequest.requester.agent
  * Zorginstelling: 
  * Contactdatums: MedicationRequest.authoredOn
  * Zorgviewer: 0--
  * Epic: 1--
  * Zorgplatform: 1--
  * Nexus: ?--
* Zib (FHIR Resource): Medicatiegebruik (MedicationStatement)
* Zib (FHIR Resource): Vitale Gegevens (Observation)
* Zib (FHIR Resource): Behandelaanwijzingen & Wilsbeschikkingen (Consent)
* Zib (FHIR Resource): Correspondentie (DocumentReference)

Legenda:
 '-' : nvt
 '0' : gegeven niet beschikbaar
 '1' : gegeven beschikbaar
 '?' : nog uitzoeken

### AGB en Fysieke Locatie

> Use AGB API om bij inzage zorgnetwerk fysieke locaties te tonen adhv de AGB codes: https://www.vektis.nl/uploads/AGB/AGB%20Raadpleegdienst%20REST%20API.pdf

