# Copyrights - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* **Copyrights**

## Copyrights

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [identifierType](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0203.html): [Bundle/eps-bundle-example](Bundle-eps-bundle-example.md)


* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.3.0/CodeSystem-ISO3166Part1.html): [ACPTreatmentCodelist](ValueSet-ACPTreatmentCodelist.md), [Adressering](CapabilityStatement-Adressering.md)...Show 55 more,[AdvanceDirective](StructureDefinition-AdvanceDirective.md),[Alert](StructureDefinition-Flag.md),[AllergyIntolerance](StructureDefinition-AllergyIntolerance.md),[Appointment](StructureDefinition-Appointment.md),[AuditEvent](StructureDefinition-AuditEvent.md),[Behandelplan](CapabilityStatement-Behandelplan.md),[BgZ2017](PlanDefinition-BgZ2017.md),[Bundle/69ecfed3-f811-45be-969c-6fb1f32fcf19](Bundle-69ecfed3-f811-45be-969c-6fb1f32fcf19.md),[CodeSystems](ValueSet-CodeSystems.md),[Condition](StructureDefinition-Condition.md),[DocumentLOINCCodelist](ValueSet-DocumentLOINCCodelist.md),[DocumentReference](StructureDefinition-DocumentReference.md),[Encounter](StructureDefinition-Encounter.md),[Endpoint](StructureDefinition-Endpoint.md),[EpisodeOfCare](StructureDefinition-EpisodeOfCare.md),[LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md),[Logging](CapabilityStatement-Logging.md),[Medicatiegegevens](StructureDefinition-Medicatiegegevens.md),[Medication](StructureDefinition-Medication.md),[MedicationAgreement](StructureDefinition-MedicationRequest.md),[MedicationUse](StructureDefinition-MedicationStatement.md),[OntsluitenBronsysteem](CapabilityStatement-OntsluitenBronsysteem.md),[OntsluitenBronsysteemSanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md),[Organization](StructureDefinition-Organization.md),[Patient](StructureDefinition-Patient.md),[Patient/330073](Patient-330073.md),[Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1](Patient-9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1.md),[Patient/B211BE58-949E-4950-9FE7-410B4D944E6F](Patient-B211BE58-949E-4950-9FE7-410B4D944E6F.md),[PatientToestemmingMapping](ConceptMap-patient-toestemming.md),[PlanDefinition](StructureDefinition-PlanDefinition.md),[Practitioner](StructureDefinition-Practitioner.md),[PractitionerRole](StructureDefinition-PractitionerRole.md),[ProbleemNaamCodelist](ValueSet-ProbleemNaamCodelist.md),[ProbleemStatus](ValueSet-ProbleemStatus.md),[Probleemlijst](StructureDefinition-Probleemlijst.md),[Procedure](StructureDefinition-Procedure.md),[Specimen](StructureDefinition-Specimen.md),[SubjectRoleCodelist](ValueSet-SubjectRoleCodelist.md),[Terminologie](CapabilityStatement-Terminologie.md),[Toestemming](CapabilityStatement-Toestemming.md),[ToestemmingConsent](StructureDefinition-ToestemmingConsent.md),[TreatmentDirective](StructureDefinition-TreatmentDirective.md),[Vaccination](StructureDefinition-Immunization.md),[VerrichtingTypeCodelist](ValueSet-VerrichtingTypeCodelist.md),[VitalSign](StructureDefinition-VitalSign.md),[ZorgverlenerDirectory](CapabilityStatement-ZorgverlenerDirectory.md),[ZorgviewerHost](CapabilityStatement-ZorgviewerHost.md),[ZorgviewerIG](index.md),[behandelaanwijzing2017to2020](ConceptMap-behandelaanwijzing-2017-2020.md),[bronsysteem-zorgaanbieder](ValueSet-bronsysteem-zorgaanbieder.md),[epictorolcode](ConceptMap-epic-rolcode.md),[extension-Meta.source](StructureDefinition-extension-Meta.source.md),[rolcodenl](ConceptMap-rolcodenl.md),[sanday](ConceptMap-sanday.md)and[vitalsignsgroups](ConceptMap-vital-signs-groups.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/5.3.0/CodeSystem-CVX.html): [Immunization/ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3](Immunization-ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3.md)


* Some content from IHE® Copyright © 2015 IHE International, Inc. This content is from the IHE Technical Frameworks and Supplements, available for free download and use at [http://www.ihe.net/Technical_Frameworks/](http://www.ihe.net/Technical_Frameworks/)

* [Endpoint Connection Type](http://hl7.org/fhir/STU3/codesystem-endpoint-connection-type.html): [UMCG](Endpoint-UMCG.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-ucum.html): [Bundle/eps-bundle-example](Bundle-eps-bundle-example.md), [Immunization/b0a09112-1141-41a5-ab3e-277dd7cf34c4](Immunization-b0a09112-1141-41a5-ab3e-277dd7cf34c4.md)...Show 11 more,[Medication](StructureDefinition-Medication.md),[Medication/fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4](Medication-fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4.md),[MedicationRequest/eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3](MedicationRequest-eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3.md),[Observation/2a35354e-9624-454c-a083-edabf7930c5a](Observation-2a35354e-9624-454c-a083-edabf7930c5a.md),[Observation/39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C](Observation-39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C.md),[Observation/8130f2fc-1fc9-4304-875e-2e5630625cee](Observation-8130f2fc-1fc9-4304-875e-2e5630625cee.md),[Observation/eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3](Observation-eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3.md),[Observation/f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4](Observation-f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4.md),[Observation/fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4](Observation-fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4.md),[Observation/fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4](Observation-fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4.md)and[Specimen/291f7eb1-c4ff-49fb-94a8-0500c19b7635](Specimen-291f7eb1-c4ff-49fb-94a8-0500c19b7635.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://hl7.org/fhir/STU3/codesystem-dicom-dcim.html): [AuditEvent/example-auditevent-zorgviewer](AuditEvent-example-auditevent-zorgviewer.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html): [Alert](StructureDefinition-Flag.md), [Bundle/69ecfed3-f811-45be-969c-6fb1f32fcf19](Bundle-69ecfed3-f811-45be-969c-6fb1f32fcf19.md)...Show 15 more,[Bundle/eps-bundle-example](Bundle-eps-bundle-example.md),[Condition/eod0yZoGGXEapUI7nJwX4tA3](Condition-eod0yZoGGXEapUI7nJwX4tA3.md),[DocumentLOINCCodelist](ValueSet-DocumentLOINCCodelist.md),[DocumentReference](StructureDefinition-DocumentReference.md),[DocumentReference/22aa9e3e-f72f-4f76-97c7-0f66c8f691f5](DocumentReference-22aa9e3e-f72f-4f76-97c7-0f66c8f691f5.md),[DocumentReference/esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi](DocumentReference-esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi.md),[Flag/354CD8791FE7BB1CF7AAC44891171ECB671D9E91](Flag-354CD8791FE7BB1CF7AAC44891171ECB671D9E91.md),[Flag/ac907bbc-89bd-45db-ab23-fdb11dd01a78](Flag-ac907bbc-89bd-45db-ab23-fdb11dd01a78.md),[Flag/fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4](Flag-fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4.md),[MedicationRequest/eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3](MedicationRequest-eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3.md),[Observation/39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C](Observation-39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C.md),[Observation/8130f2fc-1fc9-4304-875e-2e5630625cee](Observation-8130f2fc-1fc9-4304-875e-2e5630625cee.md),[Observation/f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4](Observation-f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4.md),[Observation/fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4](Observation-fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4.md)and[Observation/fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4](Observation-fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r3/ValueSet/snomedct): [ACPTreatmentCodelist](ValueSet-ACPTreatmentCodelist.md), [AdvanceDirective](StructureDefinition-AdvanceDirective.md)...Show 47 more,[Alert](StructureDefinition-Flag.md),[AllergyIntolerance/2.16.840.1.113883.2.4.3.124.7.48765.212340000000820](AllergyIntolerance-2.16.840.1.113883.2.4.3.124.7.48765.212340000000820.md),[AllergyIntolerance/41](AllergyIntolerance-41.md),[Bundle/69ecfed3-f811-45be-969c-6fb1f32fcf19](Bundle-69ecfed3-f811-45be-969c-6fb1f32fcf19.md),[Bundle/d9c8899b-210f-46ae-b336-e6e58fb73647](Bundle-d9c8899b-210f-46ae-b336-e6e58fb73647.md),[Bundle/eps-bundle-example](Bundle-eps-bundle-example.md),[CodeSystems](ValueSet-CodeSystems.md),[Condition](StructureDefinition-Condition.md),[Condition/771](Condition-771.md),[Condition/a20d2048-e1b7-467d-8bb5-28142af195d6](Condition-a20d2048-e1b7-467d-8bb5-28142af195d6.md),[Condition/e-ZZJzEApAU6z8DStznS9pQ3](Condition-e-ZZJzEApAU6z8DStznS9pQ3.md),[Consent/162](Consent-162.md),[Consent/190c12af-49d4-4553-8009-c816ab622a3e](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md),[Consent/2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449](Consent-2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449.md),[Consent/21](Consent-21.md),[Consent/81eacbcf-6d60-436a-a78f-e2962839a42f](Consent-81eacbcf-6d60-436a-a78f-e2962839a42f.md),[Consent/eCSfaTk2.C2TeVxgQk.zOgw3](Consent-eCSfaTk2.C2TeVxgQk.zOgw3.md),[Consent/eGuoY.m8DiRaUvsn.5w5Etg3](Consent-eGuoY.m8DiRaUvsn.5w5Etg3.md),[Consent/ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3](Consent-ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3.md),[DocumentReference/22aa9e3e-f72f-4f76-97c7-0f66c8f691f5](DocumentReference-22aa9e3e-f72f-4f76-97c7-0f66c8f691f5.md),[Encounter/2.16.840.1.113883.2.4.3.124.7.46240.81230000070144](Encounter-2.16.840.1.113883.2.4.3.124.7.46240.81230000070144.md),[Encounter/307375](Encounter-307375.md),[Flag/ac907bbc-89bd-45db-ab23-fdb11dd01a78](Flag-ac907bbc-89bd-45db-ab23-fdb11dd01a78.md),[Flag/fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4](Flag-fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4.md),[LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md),[MedicationRequest/2.16.840.1.113883.2.4.3.124.7.10160.01230000013923](MedicationRequest-2.16.840.1.113883.2.4.3.124.7.10160.01230000013923.md),[MedicationRequest/eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3](MedicationRequest-eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3.md),[MedicationUse](StructureDefinition-MedicationStatement.md),[Observation/3009316](Observation-3009316.md),[Observation/39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C](Observation-39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C.md),[Observation/8130f2fc-1fc9-4304-875e-2e5630625cee](Observation-8130f2fc-1fc9-4304-875e-2e5630625cee.md),[Observation/eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3](Observation-eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3.md),[Observation/f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4](Observation-f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4.md),[Practitioner](StructureDefinition-Practitioner.md),[Practitioner/e-fLnBq-lBzq8jPEBkxuqjA3-SCT](Practitioner-e-fLnBq-lBzq8jPEBkxuqjA3-SCT.md),[PractitionerRole](StructureDefinition-PractitionerRole.md),[ProbleemNaamCodelist](ValueSet-ProbleemNaamCodelist.md),[Procedure](StructureDefinition-Procedure.md),[Procedure/2.16.840.1.113883.2.4.3.124.7.47519.41230000001716](Procedure-2.16.840.1.113883.2.4.3.124.7.47519.41230000001716.md),[Procedure/25102292](Procedure-25102292.md),[Procedure/VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4](Procedure-VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4.md),[Procedure/flS.UT.hs.t2UZUFBGcd05sj4obBlLB.TD3qdy07DasQ4](Procedure-flS.UT.hs.t2UZUFBGcd05sj4obBlLB.TD3qdy07DasQ4.md),[Specimen/291f7eb1-c4ff-49fb-94a8-0500c19b7635](Specimen-291f7eb1-c4ff-49fb-94a8-0500c19b7635.md),[Specimen/edAE6aGl0-InKRnWJAWRiChE4AhLNTRTlNIiljUcUA-I3](Specimen-edAE6aGl0-InKRnWJAWRiChE4AhLNTRTlNIiljUcUA-I3.md),[SubjectRoleCodelist](ValueSet-SubjectRoleCodelist.md),[TreatmentDirective](StructureDefinition-TreatmentDirective.md)and[VerrichtingTypeCodelist](ValueSet-VerrichtingTypeCodelist.md)


* This value set includes content from LOINC® which is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at [http://loinc.org/terms-of-use](http://loinc.org/terms-of-use)

* [Consent Category Codes](http://terminology.hl7.org/5.3.0/CodeSystem-consentcategorycodes.html): [Consent/190c12af-49d4-4553-8009-c816ab622a3e](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md) and [Consent/ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3](Consent-ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3.md)


