# Artifacts Summary - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Zorgviewer Services Content 

Zie [Zorgviewer Services pagina](zorgviewer-services.md) voor details.

| | |
| :--- | :--- |
| [Organization UMCG](Organization-UMCG.md) | Deze instance bevat de organization identifiers voor het UMCG. |
| [Organization Tjongerschans](Organization-Tjongerschans.md) | Deze instance bevat de organization identifiers voor het Tjongerschans. |
| [Organization MCL](Organization-MCL.md) | Deze instance bevat de organization identifiers voor het MCL. |
| [Organization VIPLive](Organization-VIPLive.md) | Deze instance bevat de identifiers voor VIPLive. |
| [Epic UMCG Endpoint Example](Endpoint-UMCG.md) | Dit is een voorbeeld Epic Endpoint voor UMCG. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Adressering](CapabilityStatement-Adressering.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Adressering Bouwblok. |
| [Behandelplan](CapabilityStatement-Behandelplan.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Behandelplan Bouwblok. |
| [Logging](CapabilityStatement-Logging.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Logging Bouwblok. |
| [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Ontsluiten Bronsysteem Bouwblok. |
| [Ontsluiten Bronsysteem - Sanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md) | Deze CapabilityStatement beschrijft Ontsluiten Bronsysteem voor Sanday. |
| [Terminologie](CapabilityStatement-Terminologie.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Terminologie Bouwblok. |
| [Toestemming](CapabilityStatement-Toestemming.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Toestemming en Adressering Bouwblok. |
| [Zorgverlener Directory](CapabilityStatement-ZorgverlenerDirectory.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Zorgverlener Directory Bouwblok. |
| [Zorgviewer Host](CapabilityStatement-ZorgviewerHost.md) | Deze CapabilityStatement beschrijft de minimale requirements voor het Zorgviewer Host Bouwblok. |

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [Medicatiegegevens](StructureDefinition-Medicatiegegevens.md) | Medicatiegegevens abstract samenstelling voor het documenteren van de combinatie van Medicatieafspraak en Medicatie Gebruik |
| [Probleemlijst](StructureDefinition-Probleemlijst.md) | Probleemlijst abstracte samenstelling voor het documenteren van de combinatie van Condition en Conditions bij EpisodeOfCare. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AdvanceDirective](StructureDefinition-AdvanceDirective.md) | Wilsverklaring (Consent) |
| [Alert](StructureDefinition-Flag.md) | Alert (Flag) |
| [AllergyIntolerance](StructureDefinition-AllergyIntolerance.md) | Allergie & Intolerantie |
| [Appointment](StructureDefinition-Appointment.md) | Afspraak |
| [AuditEvent](StructureDefinition-AuditEvent.md) | AuditEvent |
| [Condition](StructureDefinition-Condition.md) | Problemen |
| [DocumentReference](StructureDefinition-DocumentReference.md) | Verwijzingen naar document |
| [Encounter](StructureDefinition-Encounter.md) | Contact |
| [Endpoint](StructureDefinition-Endpoint.md) | The minimal Endpoint for the Zorgviewer |
| [EpisodeOfCare](StructureDefinition-EpisodeOfCare.md) | Zorgepisode |
| [LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md) | Laboratorium Test Uitslag |
| [Medication](StructureDefinition-Medication.md) | Medicatie |
| [MedicationAgreement](StructureDefinition-MedicationRequest.md) | Medicatieafspraak |
| [MedicationUse](StructureDefinition-MedicationStatement.md) | Medicatie Gebruik |
| [Organization](StructureDefinition-Organization.md) | Instelling of Organisatie |
| [Patient](StructureDefinition-Patient.md) | Patient |
| [PlanDefinition](StructureDefinition-PlanDefinition.md) | PlanDefinition voor het ondersteunen van filtering op basis van DataRequirements |
| [Practitioner](StructureDefinition-Practitioner.md) | Zorgverlener |
| [PractitionerRole](StructureDefinition-PractitionerRole.md) | De rollen van de Zorgverlener |
| [Procedure](StructureDefinition-Procedure.md) | Verrichtingen |
| [Specimen](StructureDefinition-Specimen.md) | Monster Materiaal |
| [ToestemmingConsent](StructureDefinition-ToestemmingConsent.md) | De registatie (Consent) dat de patient de RIVO-Noord policy voor toestemming van gegevensuitwisseling heeft geaccepteerd |
| [TreatmentDirective](StructureDefinition-TreatmentDirective.md) | Advanced Care Planning (ACP) Behandelaanwijzingen (Consent) |
| [Vaccination](StructureDefinition-Immunization.md) | Vaccinatie (Immunization) |
| [VitalSign](StructureDefinition-VitalSign.md) | Vitale gegevens |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [extension-Meta.source](StructureDefinition-extension-Meta.source.md) | An extension to bring in Meta.source from R4. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [ACP behandelingen waardelijst](ValueSet-ACPTreatmentCodelist.md) | Active Care Planning (ACP) behandelingen waardelijst |
| [Bronsysteem Zorgaanbieder](ValueSet-bronsysteem-zorgaanbieder.md) | Bronsysteem Zorgaanbieder AGB-Z, OID and displays. De OID wordt gebruikt als uri in Meta.source |
| [CodeSysteem Labels](ValueSet-CodeSystems.md) | Deze waardelijst bevat de labels voor de gebruikte CodeSystemen |
| [Document Class & Type waardelijst](ValueSet-DocumentLOINCCodelist.md) | Docuemnt Class en Type LOINC codes die we vinden zonder display, zodat we wel een display in Nederlands kunnen tonen |
| [ProbleemStatus Labels](ValueSet-ProbleemStatus.md) | Deze waardelijst bevat de labels voor de Probleem (clinical)status |
| [Subject rol (beroepen) waardelijst](ValueSet-SubjectRoleCodelist.md) | Subject rol waardelijst. Deze lijst is nodig voor autorisatie opstarten Zorgviewer en is voor autorisatie bij het bronsystemen. |
| [Zorgviewer probleem naam waardelijst](ValueSet-ProbleemNaamCodelist.md) | De Zorgviewer probleem naam waardelijst o.b.v. de DHD Diagnose Thesaurus (SNOMED CT en ICD-10-nl codes) en de ICPC-1 NL coderingen vanuit de huisartsen |
| [Zorgviewer verrichting type waardelijst](ValueSet-VerrichtingTypeCodelist.md) | De Zorgviewer verrichting type waardelijst |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [Behandelaanwijzing 2017 BehandelingAanwijzing2 2020 Mapping](ConceptMap-behandelaanwijzing-2017-2020.md) | Deze ConceptMap representeert de mapping tussen de BehandelingAanwijzing 2017 en de BehandelAanwijzing2 2020. |
| [Epic Provider Type naar SNOMED-CT Mapping](ConceptMap-epic-rolcode.md) | Deze ConceptMap representeert de mapping tussen Epic Provider Type (SER#1040) naar een SNOMED-CT code. |
| [Patient Toestemming Mapping](ConceptMap-patient-toestemming.md) | Deze ConceptMap representeert de mapping van een patient-toestemming HL7 v2 bericht (PID en CON segmenten) naar FHIR Concent Resource. |
| [RolCodeNL naar SNOMED-CT Mapping](ConceptMap-rolcodenl.md) | Deze ConceptMap representeert de mapping tussen RolCodeNL naar een SNOMED-CT code. N.B. hier betekent een '*' in de code een wildcard. |
| [Sanday functies naar SNOMED-CT Mapping](ConceptMap-sanday.md) | Deze ConceptMap beschrijft de functiebenamingen die in Sanday worden gebruikt en koppelt deze aan SNOMED CT-codes. Let op: dit is een tijdelijke mapping. Sanday gebruikt momenteel functienaam-strings in plaats van gestandaardiseerde codes. De in deze mapping gebruikte codes hebben alleen betekenis binnen de context van de Zorgviewer. |
| [Vitale Gegevens Groep Mapping](ConceptMap-vital-signs-groups.md) | Deze ConceptMap representeert de mappings van de vitale gegevens codes van LOINC en NHG tabel 45 naar LOINC 'groep' codes. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Chipsoft AdvanceDirective Example](Consent-2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449.md) | Dit is een Wilsverklaring (Consent) voorbeeld uit Chipsoft. |
| [Chipsoft Alert Example](Flag-ac907bbc-89bd-45db-ab23-fdb11dd01a78.md) | Dit is een Alert voorbeeld uit Chipsoft. |
| [Chipsoft AllergyIntolerance Example](AllergyIntolerance-2.16.840.1.113883.2.4.3.124.7.48765.212340000000820.md) | Dit is een AllergyIntolerance voorbeeld uit Chipsoft. |
| [Chipsoft Condition Example](Condition-a20d2048-e1b7-467d-8bb5-28142af195d6.md) | Dit is een Probleem voorbeeld uit Chipsoft. |
| [Chipsoft DocumentReference Example](DocumentReference-22aa9e3e-f72f-4f76-97c7-0f66c8f691f5.md) | Dit is een Document Verwijzing voorbeeld uit Chipsoft. |
| [Chipsoft Immunization Example](Immunization-b0a09112-1141-41a5-ab3e-277dd7cf34c4.md) | Dit is een Immunization voorbeeld uit Chipsoft. |
| [Chipsoft Lab-uitslag Example](Observation-39E0E479029134429CCEFEE59BB98E661DE26A675AB08E9F4A1817EBC687A98C.md) | Dit is een Lab-uitslag voorbeeld uit Chipsoft. |
| [Chipsoft MedicationRequest Example](MedicationRequest-2.16.840.1.113883.2.4.3.124.7.10160.01230000013923.md) | Dit is een MedicationRequest voorbeeld uit Chipsoft. |
| [Chipsoft Patient Example](Patient-9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1.md) | Dit is een Patient voorbeeld uit Chipsoft. |
| [Chipsoft Practitioner Example](Practitioner-b5160776-43dc-43e1-9bb7-a6e3edf8e63d.md) | Dit is een Zorgverlener voorbeeld uit Chipsoft. |
| [Chipsoft Procedure Example](Procedure-2.16.840.1.113883.2.4.3.124.7.47519.41230000001716.md) | Dit is een Verrichting voorbeeld uit Chipsoft. |
| [Chipsoft Specimen Example](Specimen-35648ae9-a74d-4800-9f15-4e436ebd12c8.md) | Dit is een Specimen voorbeeld uit Chipsoft. |
| [Chipsoft TreatmentDirective Example](Consent-81eacbcf-6d60-436a-a78f-e2962839a42f.md) | Dit is een Behandelaanwijzing (Consent) voorbeeld uit Chipsoft. |
| [Chipsoft VitalSign Example](Observation-8130f2fc-1fc9-4304-875e-2e5630625cee.md) | Dit is een VitalSign voorbeeld uit Chipsoft. |
| [Epic AdvanceDirective Example](Consent-eCSfaTk2.C2TeVxgQk.zOgw3.md) | Dit is een Wilsverklaring (Consent) voorbeeld uit Epic. |
| [Epic AdvanceDirective Example](Consent-eGuoY.m8DiRaUvsn.5w5Etg3.md) | Dit is een Wilsverklaring (Consent) voorbeeld uit Epic. |
| [Epic Alert Example](Flag-fp4NreWdKGl71zKtuqY7biisS3I-b61-FLM1FcdiDNPU4.md) | Dit is een Alert voorbeeld uit Epic. |
| [Epic AllergyIntolerance Example](AllergyIntolerance-eot677ioPb4frLYJYyuabIg3.md) | Dit is een AllergyIntolerance voorbeeld uit Epic. |
| [Epic Condition Example](Condition-e-ZZJzEApAU6z8DStznS9pQ3.md) | Dit is een Probleem voorbeeld uit Epic. |
| [Epic Condition Example met overzicht notitie](Condition-eod0yZoGGXEapUI7nJwX4tA3.md) | Dit is een Probleem voorbeeld uit Epic met een overzicht notitie. |
| [Epic DocumentReference Example](DocumentReference-esCkfE4Gs407F39oUa3nrshNutfUhGSpc-H0LDMIXXub1sTx6eyOBq4OITaxvXRi.md) | Dit is een Document Verwijzing voorbeeld uit Epic. |
| [Epic Immunization Example](Immunization-e6-GYWpe6tA541IbVTqmL.KQ0y3yguI2FH9XCaDsG8gI3.md) | Dit is een Immunization voorbeeld uit Epic. |
| [Epic Immunization Example](Immunization-ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3.md) | Dit is een Immunization voorbeeld uit Epic. |
| [Epic Immunization Example](Immunization-emmoWnHUUdm1G2gaviFakSiHIeAZOAsB1DSFw4OCaA9Y3.md) | Dit is een Immunization voorbeeld uit Epic. |
| [Epic Lab-uitslag Example](Observation-eLkztXF4frEa7ZOBv9MSS9vp.TIkR.7MqI5KrsX.3m1H2WoeIQnswnT44yGd6ybl.3.md) | Dit is een Lab-uitslag voorbeeld uit Epic. |
| [Epic Lab-uitslag Example](Observation-f8UmImiPIOsQ.5po1S7e9DkjuNqOXpuSeUU-S.g-EF2c4.md) | Dit is een Lab-uitslag voorbeeld uit Epic. |
| [Epic Medication Example](Medication-fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4.md) | Dit is een Medication voorbeeld uit Epic. |
| [Epic MedicationRequest Example](MedicationRequest-eMds53eQTsCHDM2Kq35hbKnUMUW7FngCWXMhKdQvVRgs3.md) | Dit is een MedicationRequest voorbeeld uit Epic. |
| [Epic MedicationStatement Example](MedicationStatement-e2qDW3csWlKhFLAFtLX.hWRVnai3zNOL7mFdTBSalQqk3.md) | Dit is een MedicationStatement voorbeeld uit Epic. |
| [Epic Organization Example](Organization-eXovwVA3zYl3U3fBH8mdkxw3.md) | Dit is een Organisatie voorbeeld uit Epic. |
| [Epic Patient Example](Patient-eXxP1o8ZlOz21F6HXS9puLA3.md) | Dit is een Patient voorbeeld uit Epic. |
| [Epic Practitioner Example](Practitioner-e-fLnBq-lBzq8jPEBkxuqjA3.md) | Dit is een Zorgverlener voorbeeld uit Epic. |
| [Epic Practitioner Example met SNOMED CT](Practitioner-e-fLnBq-lBzq8jPEBkxuqjA3-SCT.md) | Dit is een Zorgverlener voorbeeld uit Epic waarin qualifier is vertaald van Epic SER 6000 code naar SNOMED CT. |
| [Epic PractitionerRole Example](PractitionerRole-ewlllWqLbsFaKN.d3pMMnmf2FdzTdX0132jvZktW2LP43.md) | Dit is een PractitionerRole voorbeeld uit Epic. |
| [Epic Procedure (Surgical History) Example](Procedure-VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4.md) | Dit is een Verrichting voorbeeld uit Epic (Surgical History). |
| [Epic Procedure Example](Procedure-flS.UT.hs.t2UZUFBGcd05sj4obBlLB.TD3qdy07DasQ4.md) | Dit is een Verrichting voorbeeld uit Epic. |
| [Epic Specimen Example](Specimen-edAE6aGl0-InKRnWJAWRiChE4AhLNTRTlNIiljUcUA-I3.md) | Dit is een Specimen voorbeeld uit Epic. |
| [Epic Specimen Example](Specimen-exZSk-b3OlcTzGCgPiLC7vWfuWK61KNrcmTO8gYKthmA3.md) | Dit is een Specimen voorbeeld uit Epic. |
| [Epic TreatmentDirective Example](Consent-ehLhIC8xuXjiZDVRntQauPyXlKehTcmaSh3Ozrs3nMfw3.md) | Dit is een Behandelaanwijzing (Consent) voorbeeld uit Epic. |
| [Epic VitalSign Example](Observation-fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4.md) | Dit is een VitalSign voorbeeld uit Epic. |
| [Epic VitalSign Example](Observation-fnOT.DhAM3rvu5Q8YAm3-LZHYD--XzzBJiZgxXDXElkw4.md) | Dit is een VitalSign voorbeeld uit Epic. |
| [Nexus AdvanceDirective Example](Consent-162.md) | Dit is een Wilsverklaring (Consent) voorbeeld uit Nexus. |
| [Nexus Alert Example](Flag-354CD8791FE7BB1CF7AAC44891171ECB671D9E91.md) | Dit is een Alert voorbeeld uit Nexus. |
| [Nexus AllergyIntolerance Example](AllergyIntolerance-41.md) | Dit is een AllergyIntolerance voorbeeld uit Nexus. |
| [Nexus Condition Example](Condition-771.md) | Dit is een Probleem voorbeeld uit Nexus. |
| [Nexus Immunization Example](Immunization-873.md) | Dit is een Immunization voorbeeld uit Nexus. |
| [Nexus Lab-uitslag Example](Observation-3009316.md) | Dit is een Lab-uitslag voorbeeld uit Nexus. |
| [Nexus MedicationRequest Example](MedicationRequest-MedicationRequest-Nexus.md) | Dit is een MedicationRequest voorbeeld uit Nexus. |
| [Nexus Patient Example](Patient-330073.md) | Dit is een Patient voorbeeld uit Nexus. |
| [Nexus Practitioner Example](Practitioner-67d36d4c-bc18-4c5d-8fb5-609f6a17451e.md) | Dit is een Zorgverlener voorbeeld uit Nexus. |
| [Nexus Procedure (Surgical History) Example](Procedure-25102292.md) | Dit is een Verrichting voorbeeld uit Nexus. |
| [Nexus Specimen Example](Specimen-291f7eb1-c4ff-49fb-94a8-0500c19b7635.md) | Dit is een Specimen voorbeeld uit Nexus. |
| [Nexus TreatmentDirective Example](Consent-21.md) | Dit is een Behandelaanwijzing (Consent) voorbeeld uit Nexus. |
| [Ommelander Ziekenhuis Groep locatie Delfzicht](Organization-OZGDelfzicht.md) |  |
| [PlanDefinition BgZ 2017](PlanDefinition-BgZ2017.md) | Deze PlanDefinition bevat de (data) definitie van de BgZ 2017. Dit is de basis view voor alle zorgverleners. |
| [Sanday VitalSign Example](Observation-2a35354e-9624-454c-a083-edabf7930c5a.md) | Dit is een VitalSign voorbeeld uit Sanday. |
| [Topicus TreatmentDirective Example](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md) | Dit is een Behandelaanwijzing (Consent) voorbeeld uit Topicus. |
| [Zorgviewer AuditEvent Example](AuditEvent-example-auditevent-zorgviewer.md) | Dit is een AuditEvent voorbeeld uit de Zorgviewer. |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [Appointment/2.16.840.1.113883.2.4.3.124.7.46240.80000006680](Appointment-2.16.840.1.113883.2.4.3.124.7.46240.80000006680.md) |  |
| [Appointment/euUwgaknEL2dCH5-hqEvSVp5BhPTmqDJUdEhZHe5uI-w3](Appointment-euUwgaknEL2dCH5-hqEvSVp5BhPTmqDJUdEhZHe5uI-w3.md) |  |
| [Encounter/2.16.840.1.113883.2.4.3.124.7.46240.81230000070144](Encounter-2.16.840.1.113883.2.4.3.124.7.46240.81230000070144.md) |  |
| [Encounter/307375](Encounter-307375.md) |  |
| [Encounter/evQjXbVOcndOjvpXB-f.z8A3](Encounter-evQjXbVOcndOjvpXB-f.z8A3.md) |  |
| [Patient/B211BE58-949E-4950-9FE7-410B4D944E6F](Patient-B211BE58-949E-4950-9FE7-410B4D944E6F.md) |  |
| [European Patient Summary (Bundle)](Bundle-eps-bundle-example.md) |  |
| [Parameters for Terminology selection of Netherlands SNOMED CT Edition](Parameters-exp-params.md) | This parameter resource is used to specify the system version of Netherlands SNOMED CT Edition to be used in the terminology service. |
| [null (Bundle)](Bundle-19c74840-1ae3-4d6a-9585-802ea27e31d2.md) |  |
| [null (Bundle)](Bundle-69ecfed3-f811-45be-969c-6fb1f32fcf19.md) |  |
| [null (Bundle)](Bundle-d9c8899b-210f-46ae-b336-e6e58fb73647.md) |  |

