# Subject rol (beroepen) waardelijst - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subject rol (beroepen) waardelijst**

## ValueSet: Subject rol (beroepen) waardelijst 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:SubjectRoleCodelist |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Subject rol waardelijst. Deze lijst is nodig voor autorisatie opstarten Zorgviewer en is voor autorisatie bij het bronsystemen. 

 **References** 

* [Practitioner](StructureDefinition-Practitioner.md)
* [PractitionerRole](StructureDefinition-PractitionerRole.md)

**Changes since version 1.21.0:**

* The resource metadata has changed (description)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SubjectRoleCodelist",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
  "version" : "1.22.0",
  "name" : "SubjectRoleCodelist",
  "title" : "Subject rol (beroepen) waardelijst",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Subject rol waardelijst. Deze lijst is nodig voor autorisatie opstarten Zorgviewer en is voor autorisatie bij het bronsystemen.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "223366009",
            "display" : "Healthcare professional",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "gezondheidszorgpersoneel"
              }
            ]
          },
          {
            "code" : "309343006",
            "display" : "Medical doctor",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "arts"
              }
            ]
          },
          {
            "code" : "449161006",
            "display" : "Physician assistant",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "physician assistant"
              }
            ]
          },
          {
            "code" : "224571005",
            "display" : "Nurse practitioner",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verpleegkundige specialist"
              }
            ]
          },
          {
            "code" : "62247001",
            "display" : "Family medicine specialist",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "huisarts"
              }
            ]
          },
          {
            "code" : "394572006",
            "display" : "Medical secretary",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "medisch secretaresse/mma"
              }
            ]
          },
          {
            "code" : "309445003",
            "display" : "Anesthetic nurse",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "anesthesiemedewerker"
              }
            ]
          },
          {
            "code" : "106292003",
            "display" : "Professional nurse",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verpleegkundige"
              }
            ]
          },
          {
            "code" : "106294002",
            "display" : "Midwifery personnel",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verloskundige"
              }
            ]
          },
          {
            "code" : "46255001",
            "display" : "Pharmacist",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "apotheker"
              }
            ]
          },
          {
            "code" : "1255517001",
            "display" : "Intern in healthcare",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "co-assistent"
              }
            ]
          },
          {
            "code" : "405277009",
            "display" : "Resident physician",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "arts-assistent"
              }
            ]
          },
          {
            "code" : "159282002",
            "display" : "Laboratory technician",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "laboratoriumtechnicus"
              }
            ]
          },
          {
            "code" : "73265009",
            "display" : "Nursing aid",
            "designation" : [
              {
                "language" : "nl-NL",
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000013009",
                  "display" : "Synonym"
                },
                "value" : "verzorgende"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
