# ToestemmingConsent - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ToestemmingConsent**

## Resource Profile: ToestemmingConsent 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:ToestemmingConsent |

 
De registatie (Consent) dat de patient de RIVO-Noord policy voor toestemming van gegevensuitwisseling heeft geaccepteerd 

**De specificatie op deze pagina is work-in-progress.**

### Mappings

* [HL7 v2 ADT^A08 en ADT^A31 mapping van PID en CON segmenten](ConceptMap-patient-toestemming.md)

### Request

1. Opvragen (search) toestemmingen voor een patient`GET <toestemming-base>/Consent?patient:Patient.identifier=<BSN>`N.B. Bij geen resultaat heeft de patient expliciet geen toestemming gegeven of nog niet toestemming gegeven.

**Usages:**

* CapabilityStatements using this Profile: [Toestemming](CapabilityStatement-Toestemming.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/ToestemmingConsent)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ToestemmingConsent.csv), [Excel](StructureDefinition-ToestemmingConsent.xlsx), [Schematron](StructureDefinition-ToestemmingConsent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ToestemmingConsent",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent",
  "version" : "1.22.0",
  "name" : "ToestemmingConsent",
  "title" : "ToestemmingConsent",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "De registatie (Consent) dat de patient de RIVO-Noord policy voor toestemming van gegevensuitwisseling heeft geaccepteerd",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.status",
        "path" : "Consent.status",
        "mustSupport" : true
      },
      {
        "id" : "Consent.category.coding.code",
        "path" : "Consent.category.coding.code",
        "fixedCode" : "Doss. delen?",
        "mustSupport" : true
      },
      {
        "id" : "Consent.patient",
        "path" : "Consent.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Consent.period",
        "path" : "Consent.period",
        "mustSupport" : true
      },
      {
        "id" : "Consent.organization",
        "path" : "Consent.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Consent.policy",
        "path" : "Consent.policy",
        "mustSupport" : true
      },
      {
        "id" : "Consent.policy.uri",
        "path" : "Consent.policy.uri",
        "fixedUri" : "https://rivo-noord.nl/zorgviewer/toestemming",
        "mustSupport" : true
      }
    ]
  }
}

```
