# Practitioner - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner**

## Resource Profile: Practitioner 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Practitioner |

 
Zorgverlener 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Zorgverlener](https://zibs.nl/wiki/Zorgverlener-v3.2(2017NL))

### Zoeken naar codes

* [Vektiz AGB Register zoeken](https://www.vektis.nl/agb-register/zoeken)

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md), [Zorgverlener Directory](CapabilityStatement-ZorgverlenerDirectory.md) and [Zorgviewer Host](CapabilityStatement-ZorgviewerHost.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Practitioner)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Practitioner.csv), [Excel](StructureDefinition-Practitioner.xlsx), [Schematron](StructureDefinition-Practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Practitioner",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner",
  "version" : "1.22.0",
  "name" : "Practitioner",
  "title" : "Practitioner",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Zorgverlener",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-contactinformation-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.0(2017EN)",
      "name" : "HCIM ContactInformation-v1.0(2017EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-contactinformation-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.0(2016EN)",
      "name" : "HCIM Patient-v3.0(2016EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs"
    },
    {
      "identity" : "hcim-contactinformation-v2.0.1-2015EN",
      "uri" : "https://zibs.nl/wiki/Patient-v2.0.1(2015EN)",
      "name" : "HCIM Patient-v2.0.1(2015EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "constraint" : [
          {
            "key" : "zv-pra-3",
            "severity" : "error",
            "human" : "Either Practitioner BIG or AGB-Z identifier SHALL be present.",
            "expression" : "identifier.where(system='http://fhir.nl/fhir/NamingSystem/agb-z') or identifier.where(system='http://fhir.nl/fhir/NamingSystem/big')",
            "xpath" : "/f:identifier/f:system='http://fhir.nl/fhir/NamingSystem/agb-z' or /f:identifier/f:system='http://fhir.nl/fhir/NamingSystem/big'"
          }
        ]
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:AGB",
        "path" : "Practitioner.identifier",
        "sliceName" : "AGB",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:BIG",
        "path" : "Practitioner.identifier",
        "sliceName" : "BIG",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "zv-pra-1",
            "severity" : "error",
            "human" : "Either Practitioner.name.given and/or Practitioner.name.family and/or Practitioner.name.text SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists())",
            "xpath" : "/f:name/f:family or /f:name/f:given or /f:name/f:text"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice",
                "valueBoolean" : true
              }
            ],
            "key" : "zv-pra-2",
            "severity" : "warning",
            "human" : "To be usable for a wide range of internationally available applications, the Patient.name.text SHOULD be present.",
            "expression" : "text.exists()",
            "xpath" : "/f:name/f:text"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "constraint" : [
          {
            "key" : "zv-pra-4",
            "severity" : "warning",
            "human" : "A SNOMED CT (beroep) code SHOULD be present.",
            "expression" : "code.coding.where(system='http://snomed.info/sct')",
            "xpath" : "/f::code/f:coding/f:system='http://snomed.info/sct'"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Subject rol waardelijst. Deze rol is nodig voor autorisatie bij de bron.",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist"
          }
        }
      }
    ]
  }
}

```
