# PlanDefinition - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlanDefinition**

## Resource Profile: PlanDefinition 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/PlanDefinition | *Version*:1.22.0 |
| Draft as of 2026-01-12 | *Computable Name*:PlanDefinition |

 
PlanDefinition voor het ondersteunen van filtering op basis van DataRequirements 

**De specificatie op deze pagina is work-in-progress.**

### Example

* [BgZ2017 DataRequirements in scope voor MVP2](PlanDefinition-BgZ2017.md)

### Request

1. Opvragen (search) definities`GET <behandelplan-base>/PlanDefinition?name=BgZ2017`

**Usages:**

* CapabilityStatements using this Profile: [Behandelplan](CapabilityStatement-Behandelplan.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/PlanDefinition)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PlanDefinition.csv), [Excel](StructureDefinition-PlanDefinition.xlsx), [Schematron](StructureDefinition-PlanDefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlanDefinition",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/PlanDefinition",
  "version" : "1.22.0",
  "name" : "PlanDefinition",
  "title" : "PlanDefinition",
  "status" : "draft",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "PlanDefinition voor het ondersteunen van filtering op basis van DataRequirements",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PlanDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/PlanDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PlanDefinition",
        "path" : "PlanDefinition"
      },
      {
        "id" : "PlanDefinition.relatedArtifact",
        "path" : "PlanDefinition.relatedArtifact",
        "comment" : "Zet hier een link naar de 'officiele' specificaties van het Behandelplan.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action.output",
        "path" : "PlanDefinition.action.output",
        "comment" : "Specificeer hier de zib FHIR resource en hun filters.",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
