# MedicationAgreement - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationAgreement**

## Resource Profile: MedicationAgreement 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:MedicationAgreement |

 
Medicatieafspraak 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Medicatieafspraak](https://zibs.nl/wiki/Medicatieafspraak-v1.0.1(2017NL))

### View Definition

[ViewDefinition voor MedicationRequest](ViewDefinition-MedicationRequest.json)

### UI Wireframe

**Medicatie Afspraken**

* ><: +
  * Bron: Chipsoft
  * Start: 15-8-2016
  * Eind: 14-9-2016
  * Medicatie: METOCLOPRAMIDE ZETPIL 10MG
  * Dosering & instructies: 1x elke 1 dag, indien nodig (Zo nodig)Aanvullende instructie 1: Pas op met alc...
  * Toedieningsweg: RECTAAL
  * Stop type: Definitief
* ><: 
  * Bron: **Afspraakdatum**30-9-2022**Voorschrijver**Peter van Pulver
* ><: +
  * Bron: Epic
  * Start: 27-11-2020
  * Eind: 
  * Medicatie: metoPROLOL 50mg tablet
  * Dosering & instructies: 1x per dag 50 mg innemen.
  * Toedieningsweg: Oraal
  * Stop type: 
* ><: 
  * Bron: **Medicatie vorm**tablet**Afspraakdatum**27-11-2020**Voorschrijver**M Crop
* ><: +
  * Bron: Nexus
  * Start: 3-10-2023
  * Eind: 
  * Medicatie: GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML
  * Dosering & instructies: 1x elke 1 dag om 08:00:00 ⓘ
  * Toedieningsweg: INTRAVENEUS
  * Stop type: 
* ><: 
  * Bron: **Afspraakdatum**3-10-2023**Voorschrijver**Aalders, JCA (CAR)
* ><: +
  * Bron: Sanday
  * Start: 7-8-2025
  * Eind: 20-9-2025
  * Medicatie: PANTOPRAZOL TABLET MSR 40MG
  * Dosering & instructies: 2 maal per dag 1 tablet;1 TABLET 1 UUR VOOR DE MAALTIJD
  * Toedieningsweg: 
  * Stop type: 
* ><: 
  * Bron: **Afspraakdatum**6-8-2025**Voorschrijver**Jenneke van der Vecht

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Start
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-Medication-PeriodOfUse').valuePeriod.start | extension('http://nictiz.nl/fhir/StructureDefinition/ext-TimeInterval.Period').valuePeriod.start`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/startDatumTijd
  * ?: 
* UITKLAPVELD: Eind
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-Medication-PeriodOfUse').valuePeriod.end | extension('http://nictiz.nl/fhir/StructureDefinition/ext-TimeInterval.Period').valuePeriod.end`
  * ?: `dateTime`
  * ?: Gebruiksperiode::TijdsInterval/eindDatumTijd
  * ?: 
* UITKLAPVELD: Medicatie
  * ?: `medication.display`
  * ?: `string`
  * ?: Afgesprokengeneesmiddel::Product
  * ?: 
* UITKLAPVELD: Dosering & instructies
  * ?: `dosageInstruction.text | extension('http://nictiz.nl/fhir/StructureDefinition/ext-RenderedDosageInstruction').valueString`
  * ?: `string`
  * ?: Gebruiksinstructie/Omschrijving, Gebruiksinstructie/AanvullendeInstructie
  * ?: N.B. Als text niet beschikbaar dan samenstellen uit discrete informatie en markeren met een icoontje ⓘ
* UITKLAPVELD: Toedieningsweg
  * ?: `iif(exists(dosageInstruction.route.text), dosageInstruction.route.text, dosageInstruction.route.coding.display)`
  * ?: `string`
  * ?: Gebruiksinstructie/Toedieningsweg
  * ?: 
* UITKLAPVELD: Stop type
  * ?: `modifierExtension.where(url='http://nictiz.nl/fhir/StructureDefinition/zib-Medication-StopType').valueCodeableConcept.coding.display`
  * ?: `string`
  * ?: StopType
  * ?: 
* UITKLAPVELD: +Medicatie vorm
  * ?: `medication.resolve().form.coding.display`
  * ?: `string`
  * ?: Afgesprokengeneesmiddel::FarmaceutischProduct/FarmaceutischeVorm
  * ?: 
* UITKLAPVELD: +Afspraakdatum
  * ?: `authoredOn`
  * ?: `dateTime`
  * ?: MedicatieafspraakDatumTijd
  * ?: 
* UITKLAPVELD: +Voorschrijver
  * ?: `requester.agent.display | requester.display`
  * ?: `string`
  * ?: Voorschrijver::Zorgverlener
  * ?: **LET OP:**`requester.display`is een FHIR R4 veld

### Request

1. Opvragen (search) definities`GET <ontsluiten-bronsysteem-base>/MedicationRequest?category=http://snomed.info/sct|16076005&_include=MedicationRequest:medication&patient=<fhir_patient_id>`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Use this Profile: [Medicatiegegevens](StructureDefinition-Medicatiegegevens.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem - Sanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md) and [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/MedicationRequest)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationRequest.csv), [Excel](StructureDefinition-MedicationRequest.xlsx), [Schematron](StructureDefinition-MedicationRequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationRequest",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest",
  "version" : "1.22.0",
  "name" : "MedicationAgreement",
  "title" : "MedicationAgreement",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Medicatieafspraak",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-medicationagreement-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/MedicationAgreement-v1.0(2017EN)",
      "name" : "HCIM MedicationAgreement-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-instructionsforuse-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/InstructionsForUse-v1.0(2017EN)",
      "name" : "HCIM InstructionsForUse-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "Medication-Process-v09",
      "uri" : "https://decor.nictiz.nl/medicatieproces/mp-html-20181220T121121/ds-2.16.840.1.113883.2.4.3.11.60.20.77.1.3-2016-06-01T000000.html",
      "name" : "Medication Process v09",
      "comment" : "Language of Medication Process is Dutch."
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationAgreement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest.extension:periodOfUse",
        "path" : "MedicationRequest.extension",
        "sliceName" : "periodOfUse",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.modifierExtension:stopType",
        "path" : "MedicationRequest.modifierExtension",
        "sliceName" : "stopType",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.category.text",
        "path" : "MedicationRequest.category.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medicationReference",
        "path" : "MedicationRequest.medicationReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medication"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medicationReference.display",
        "path" : "MedicationRequest.medicationReference.display",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.requester.agent.display",
        "path" : "MedicationRequest.requester.agent.display",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route.text",
        "path" : "MedicationRequest.dosageInstruction.route.text",
        "mustSupport" : true
      }
    ]
  }
}

```
