# Alert - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alert**

## Resource Profile: Alert 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Alert |

 
Alert (Flag) 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Alert](https://zibs.nl/wiki/Alert-v3.2(2017NL))

### View Definition

[ViewDefinition voor Alerts](ViewDefinition-Flag.json)

### UI Wireframe

**Alerts / Waarschuwingen**

* ><: +
  * Bron: Chipsoft-OTH
  * Datum: 15-4-2019
  * Voor(1): BRMO: Bewezen dragerschap
  * Voor(2): Anders
  * Voor(3): other
  * Categorie: conditie
  * Status(1): active
  * Status(2): active
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-OTH
  * Datum: 19-7-2024
  * Voor(1): MRSA: Bewezen dragerschap
  * Voor(2): Anders
  * Voor(3): other
  * Categorie: conditie
  * Status(1): active
  * Status(2): active
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft
  * Datum: 1-6-2010
  * Voor(1): 
  * Voor(2): Drager MRSA
  * Voor(3): 
  * Categorie: waarschuwing
  * Status(1): 
  * Status(2): active
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 10-5-2022
  * Voor(1): 
  * Voor(2): TBC
  * Voor(3): 
  * Categorie: Infection Flag
  * Status(1): 
  * Status(2): inactive
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Datum: 16-5-2022
  * Voor(1): 
  * Voor(2): LET OP!!!!!Deze patient wordt gebruikt voor de (her)kwalificatie voor VIPP 5. ...
  * Voor(3): 
  * Categorie: Waarschuwing
  * Status(1): 
  * Status(2): active
* ><: 
  * Bron: 

### Kolom Definities

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Bron | `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri` | `string` | nvt | Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name` |
| Datum | `period.start` | `dateTime` | BeginDatumTijd |  |
| Voor(1) | `extension.where('http://hl7.org/fhir/StructureDefinition/flag-detail').valueReference.resolve().code.text` | `string` | Conditie::Probleem | Als geen Voor(1), dan Voor(2), als geen Voor(2) dan Voor(3).*De flag-detail Condition opzoeken in de resultaat Bundle.* |
| Voor(2) | `code.text | code.coding[0].display` | `string` | AlertNaam |  |
| Voor(3) | `extension('http://hl7.org/fhir/StructureDefinition/flag-detail').valueReference.display` | `string` | Conditie::Probleem |  |
| Categorie | `iif(exists(category.text),category.text,category.coding.display)` | `string` | AlertType |  |
| Status(1) | `extension('http://hl7.org/fhir/StructureDefinition/flag-detail').valueReference.resolve().clinicalStatus` | `code` | Conditie::Probleem/ProbleemStatus | Logica: als geen Status(1), dan Status(2)Mapping:`active,recurrence`naar`Actueel`;`inactive,remission`naar`Niet actueel` |
| Status(2) | `status` | `code` | nvt | Mapping:`active`naar`Actueel`;`inactive`naar`Niet actueel`Uitgefilterd:`entered-in-error`wordt niet getoond in de Zorgviewer, omdat het om foutief ingevoerde data gaat. |

### Request

1. Opvragen (search) alerts`GET <ontsluiten-bronsysteem-base>/Flag?patient=<fhir_patient_id>`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Flag)

**Changes since version 1.21.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Flag.csv), [Excel](StructureDefinition-Flag.xlsx), [Schematron](StructureDefinition-Flag.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Flag",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag",
  "version" : "1.22.0",
  "name" : "Alert",
  "title" : "Alert",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Alert (Flag)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-alert-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/Alert-v3.2(2017EN)",
      "name" : "HCIM Alert-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-alert-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Alert-v3.0(2016EN)",
      "name" : "HCIM Alert-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-alert-v1.0-2015EN",
      "uri" : "https://zibs.nl/wiki/Alert-v1.0(2015EN)",
      "name" : "HCIM Alert-v1.0(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Flag",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Alert",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Flag",
        "path" : "Flag"
      },
      {
        "id" : "Flag.extension:ConcernReference",
        "path" : "Flag.extension",
        "sliceName" : "ConcernReference",
        "type" : [
          {
            "code" : "Extension",
            "profile" : "http://hl7.org/fhir/StructureDefinition/flag-detail"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Flag.category.text",
        "path" : "Flag.category.text",
        "mustSupport" : true
      },
      {
        "id" : "Flag.code.text",
        "path" : "Flag.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Flag.period.start",
        "path" : "Flag.period.start",
        "mustSupport" : true
      }
    ]
  }
}

```
