# Endpoint - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Endpoint**

## Resource Profile: Endpoint 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint | *Version*:1.22.0 |
| Draft as of 2026-01-12 | *Computable Name*:Endpoint |

 
The minimal Endpoint for the Zorgviewer 

**Usages:**

* CapabilityStatements using this Profile: [Adressering](CapabilityStatement-Adressering.md) and [Toestemming](CapabilityStatement-Toestemming.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Endpoint)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Endpoint.csv), [Excel](StructureDefinition-Endpoint.xlsx), [Schematron](StructureDefinition-Endpoint.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Endpoint",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint",
  "version" : "1.22.0",
  "name" : "Endpoint",
  "title" : "Endpoint",
  "status" : "draft",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "The minimal Endpoint for the Zorgviewer",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Endpoint",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Endpoint",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Endpoint",
        "path" : "Endpoint"
      },
      {
        "id" : "Endpoint.managingOrganization",
        "path" : "Endpoint.managingOrganization",
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.address",
        "path" : "Endpoint.address",
        "mustSupport" : true
      }
    ]
  }
}

```
