# Condition - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition**

## Resource Profile: Condition 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Condition |

 
Problemen 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Probleem](https://zibs.nl/wiki/Probleem-v4.1(2017NL))

### FMS Adequate Registratie

Als bron voor de must-support flags en de UI guidance is gebruikt: [Fit-gap analyse probleem](https://amigo.nictiz.nl/uploads/e4a96295-3715-439b-804a-024ca1d7fadf/fit_gap_analyse_Probleeem.pdf)

### View Definition

[ViewDefinition voor Problemen](ViewDefinition-Condition.json)

### UI Wireframe

**Problemen (incl. diagnosen)**

* ><: +
  * Bron: EPS
  * Datum: 21-1-2020
  * Diagnose: Osteoarthritis of knee
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#239873007 Osteoarthritis of knee (disorder)
* ><: +
  * Bron: EPS
  * Datum: 4-2-2014
  * Diagnose: Fibromyalgia
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#203082005 Fibromyalgia (disorder)
* ><: +
  * Bron: EPS
  * Datum: 29-1-2002
  * Diagnose: Chronic sinusitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#40055000 Chronic sinusitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 20-4-2022
  * Diagnose: Acute viral pharyngitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#195662009 Acute viral pharyngitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 21-2-2020
  * Diagnose: Viral sinusitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#444814009 Viral sinusitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 9-6-2019
  * Diagnose: Miscarriage in first trimester
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#19169002 Miscarriage in first trimester (disorder)
* ><: +
  * Bron: EPS
  * Datum: 9-6-2019
  * Diagnose: Complete miscarriage
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#156073000 Complete miscarriage (disorder)
* ><: +
  * Bron: Chipsoft
  * Datum: 1-1-2001
  * Diagnose: fractuur van pols
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**NullFlavor#OTH other**Toelichting**Gevallen op kunstijsbaan.
* ><: +
  * Bron: Epic-note
  * Datum: 23-2-2023
  * Diagnose: posttraumatische stressstoornis (incl. de posttraumatische-stressstoornis bij ki...
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICD-10#F43.1**Toelichting**2022-02: ziekte van Crohn2021-07: Complicatie ANPY infectie lokaal2021-03: z...
* ><: +
  * Bron: Epic
  * Datum: 16-8-2012
  * Diagnose: fractuur van onderste extremiteit
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICD-10#T12.0
* ><: +
  * Bron: Nexus
  * Datum: 1-1-2001
  * Diagnose: fractuur van pols
  * Status: Niet actueel
  * (regelkleur): inactive
* ><: 
  * Bron: **Diagnose**SNOMED CT#31641000146105 fractuur van pols**Toelichting**Gevallen op kunstijsbaan

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `onsetPeriod.start | onsetDateTime`
  * ?: `dateTime`
  * ?: ProbleemBeginDatum
  * ?: Laat één datum zien als de`.onsetDateTime`en`.onsetPeriod`hetzelfde zijn
* UITKLAPVELD: Diagnose
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: ProbleemNaam
  * ?: 
* UITKLAPVELD: Status
  * ?: `clinicalStatus.lookup('ProbleemStatus').display`
  * ?: `code`
  * ?: ProbleemStatus
  * ?: Zie voor labels:[ValueSet-ProbleemStatus](ValueSet-ProbleemStatus.md)
* UITKLAPVELD: +Diagnose
  * ?: `code.coding[0].select(system.lookup('CodeSystems')[0].display+'#' + code + ' ' + iif(exists(display),display,''))`
  * ?: `string`
  * ?: ProbleemNaam
  * ?: Meerdere codes mogelijk.Ignore NullFlavor.Lookup system label middels`<terminologie-base>/CodeSystem?url=<.system>`en gebruik dan`.display`Zie voor labels:[ValueSet-CodeSystems](ValueSet-CodeSystems.md)
* UITKLAPVELD: +Toelichting
  * ?: `note.text`
  * ?: `string`
  * ?: Toelichting
  * ?: 
* UITKLAPVELD: MARKERING
* UITKLAPVELD: (regelkleur)
  * ?: `clinicalStatus`
  * ?: `code`
  * ?: ProbleemStatus
  * ?: Actueel (`active,recurrence`) = groene rijen, dikgedruktNiet actueel (`inactive,remission,resolved`) = grijze rijen

### Zoeken naar codes

* [DHD T-Rex](https://trex.dhd.nl/) - `system=http://snomed.info/sct`
* [ICD-10-NL](https://terminologie.nictiz.nl/art-decor/claml?collection=icd10-nl-data) - `system=http://hl7.org/fhir/sid/icd-10-nl`
* [ICPC-1 NL](https://viewers.nhg.org/icpcviewer/) - `system=http://hl7.org/fhir/sid/icpc-1-nl`

### Request

1. Opvragen (search) actieve en gesloten problemen`GET <ontsluiten-bronsysteem-base>/Condition?patient=<fhir_patient_id>[&clinical-status=active,resolved]`
> N.B. De clinical-status parameter is niet meer nodig als de Epic Feb '23 is geinstalleerd.

### Uitzondering onsetDateTime, onsetPeriod, abatementDateTime en abatementPeriod

> N.B. In tegenstelling tot het officiele zib profiel wordt in de praktijk voor de onset zowel een exacte datum (dateTime) geaccepteerd als een vage of range (period, b.v. ergens in 2011) datum.

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Use this Profile: [Probleemlijst](StructureDefinition-Probleemlijst.md)
* Refer to this Profile: [EpisodeOfCare](StructureDefinition-EpisodeOfCare.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem - Sanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md) and [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Condition)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition.csv), [Excel](StructureDefinition-Condition.xlsx), [Schematron](StructureDefinition-Condition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition",
  "version" : "1.22.0",
  "name" : "Condition",
  "title" : "Condition",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Problemen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-problem-v4.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Problem-v4.1(2017EN)",
      "name" : "HCIM Problem-v4.1(2017EN)",
      "comment" : "ConcernForTransfer is renamed to Problem with release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-concernfortransfer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/ConcernForTransfer-v3.0(2016EN)",
      "name" : "HCIM ConcernForTransfer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-concernfortransfer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/ConcernForTransfer-v1.2(2015EN)",
      "name" : "HCIM ConcernForTransfer-v1.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Problem",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "constraint" : [
          {
            "key" : "zv-con-1",
            "severity" : "error",
            "human" : "At least one of Condition.onsetDateTime or Condition.onsetPeriod SHALL be present",
            "expression" : "onsetDateTime.exists() or onsetPeriod.exists()",
            "xpath" : "f:onsetDateTime or f:onsetPeriod"
          }
        ]
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/ProbleemNaamCodelist"
          }
        }
      },
      {
        "id" : "Condition.code.text",
        "path" : "Condition.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "mustSupport" : true
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "mustSupport" : true
      }
    ]
  }
}

```
