# Chipsoft VitalSign Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft VitalSign Example**

## Example Observation: Chipsoft VitalSign Example

### Observation resource for blood pressure:

* **Patient:** 'Johan XXX_Helleman_Afblijven'
* **Systolic blood pressure:** '108 mm[Hg]'
* **Diastolic blood pressure:** '56 mm[Hg]'
* **Average blood pressure:** '73 mm[Hg]'
* **Effective:** '7-2-2013 08:53+0100'
* **Body site:** 'Left upper arm structure'
* **Method:** 'Non-invasive'
* **Position:** 'Sitting position'
* **Status:** 'Registered'
* **Code:** '85354-9'



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "8130f2fc-1fc9-4304-875e-2e5630625cee",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-BloodPressure"
    ]
  },
  "status" : "registered",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85354-9",
        "display" : "Blood pressure panel with all children optional"
      }
    ],
    "text" : "Blood pressure panel with all children optional"
  },
  "subject" : {
    "reference" : "Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1",
    "display" : "Johan XXX_Helleman_Afblijven"
  },
  "effectiveDateTime" : "2013-02-07T08:53:00+01:00",
  "bodySite" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "368208006",
        "display" : "Left upper arm structure"
      }
    ],
    "text" : "Linker bovenarm"
  },
  "method" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "22762002",
        "display" : "Non-invasive"
      }
    ],
    "text" : "Niet-invasief"
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure"
          }
        ],
        "text" : "Systolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 108,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure"
          }
        ],
        "text" : "Diastolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 56,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "6797001",
            "display" : "Mean blood pressure"
          }
        ],
        "text" : "Mean blood pressure"
      },
      "valueQuantity" : {
        "value" : 73,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8478-0",
            "display" : "Mean blood pressure"
          }
        ],
        "text" : "Mean blood pressure"
      },
      "valueQuantity" : {
        "value" : 73,
        "unit" : "mm[Hg]",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "424724000",
            "display" : "Body position for blood pressure measurement"
          }
        ],
        "text" : "Body position for blood pressure measurement"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "33586001",
            "display" : "Sitting position"
          }
        ],
        "text" : "Zittende positie"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8361-8",
            "display" : "Body position with respect to gravity"
          }
        ],
        "text" : "Body position with respect to gravity"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "33586001",
            "display" : "Sitting position"
          }
        ],
        "text" : "Zittende positie"
      }
    }
  ]
}

```
