# Epic UMCG Endpoint Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic UMCG Endpoint Example**

## Endpoint: Epic UMCG Endpoint Example

**status**: Test

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://hl7.org/fhir/STU3/codesystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: UMCG

**managingOrganization**: [Organization UMCG](Organization-eXovwVA3zYl3U3fBH8mdkxw3.md)

**payloadType**: Patient

**payloadMimeType**: application/fhir+json, application/json+fhir, application/xml+fhir, application/fhir+xml

**address**: [https:///example.org/TST-OAUTH2/api/FHIR/STU3/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "UMCG",
  "status" : "test",
  "connectionType" : {
    "system" : "http://hl7.org/fhir/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "UMCG",
  "managingOrganization" : {
    "reference" : "Organization/eXovwVA3zYl3U3fBH8mdkxw3"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/resource-types",
          "code" : "Patient"
        }
      ]
    }
  ],
  "payloadMimeType" : [
    "application/fhir+json",
    "application/json+fhir",
    "application/xml+fhir",
    "application/fhir+xml"
  ],
  "address" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/"
}

```
