# Chipsoft AdvanceDirective Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft AdvanceDirective Example**

## Example Consent: Chipsoft AdvanceDirective Example

Profile: [HCIM AdvanceDirective](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective)

**Comment**: Niet-reanimerenpenning

**identifier**: `urn:oid:2.16.840.1.113883.2.4.3.124.7.42348.3.2`/1230000026449

**status**: Active

**category**: Living will and advance directive record, Patiëntinformatie - Wilsbeschikkingen

**patient**: [Johan XXX_Helleman_Afblijven](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1)

**dateTime**: 2018-04-09

**source**: application/pdf: WFhYCg==

**policyRule**: [http://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://wetten.overheid.nl/)



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "2.16.840.1.113883.2.4.3.124.7.42348.3.21230000026449",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/Comment",
      "valueString" : "Niet-reanimerenpenning"
    }
  ],
  "identifier" : {
    "system" : "urn:oid:2.16.840.1.113883.2.4.3.124.7.42348.3.2",
    "value" : "1230000026449"
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11341000146107",
          "display" : "Living will and advance directive record"
        }
      ],
      "text" : "Living will and advance directive record"
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/v3/NullFlavor",
          "code" : "OTH",
          "display" : "other"
        }
      ],
      "text" : "Patiëntinformatie - Wilsbeschikkingen"
    }
  ],
  "patient" : {
    "reference" : "http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1",
    "display" : "Johan XXX_Helleman_Afblijven"
  },
  "dateTime" : "2018-04-09",
  "sourceAttachment" : {
    "contentType" : "application/pdf",
    "data" : "WFhYCg=="
  },
  "policyRule" : "http://wetten.overheid.nl/"
}

```
