# Vitale Gegevens Groep Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vitale Gegevens Groep Mapping**

## ConceptMap: Vitale Gegevens Groep Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/vital-signs-groups | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:vitalsignsgroups |

 
Deze ConceptMap representeert de mappings van de vitale gegevens codes van LOINC en NHG tabel 45 naar LOINC 'groep' codes. 

Deze ConceptMap mappings worden gebruikt om vitale gegevens te groeperen. Groep ( LOINC code) opzoeken door `wider` mapping te volgen van NHG tabel 45 en LOINC. Zie ook [Mapping NHG en LOINC](https://stichtinglegio.nl/wp-content/uploads/2021/11/20211124-zelfmetingen-OPEN-en-vrije-tekst.xlsx) op de pagina van [VIPP OPEN](https://stichtinglegio.nl/projecten/vipp-open/).



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "vital-signs-groups",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/vital-signs-groups",
  "version" : "1.22.0",
  "name" : "vitalsignsgroups",
  "title" : "Vitale Gegevens Groep Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap representeert de mappings van de vitale gegevens codes van LOINC en NHG tabel 45 naar LOINC 'groep' codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "sourceUri" : "Bronsysteem",
  "targetUri" : "http://loinc.org",
  "group" : [
    {
      "source" : "http://loinc.org",
      "target" : "http://loinc.org",
      "element" : [
        {
          "code" : "55284-4",
          "display" : "Blood pressure systolic and diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "85354-9",
          "display" : "RR",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8480-6",
          "display" : "Systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8462-4",
          "display" : "Diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8478-0",
          "display" : "MAP",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "9279-1",
          "display" : "Respiratory rate",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2708-6",
          "display" : "Oxygen saturation in Arterial blood",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "59408-5",
          "display" : "Oxygen saturation in Arterial blood by Pulse oximetry",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8867-4",
          "display" : "Heart rate",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8893-0",
          "display" : "Heart rate Peripheral artery by Palpation",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8302-2",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "29463-7",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "8310-5",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33052-8",
              "display" : "Temperatuur",
              "equivalence" : "wider"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen",
      "target" : "http://loinc.org",
      "element" : [
        {
          "code" : "1744",
          "display" : "systolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1740",
          "display" : "diastolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2055",
          "display" : "systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2056",
          "display" : "diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "35094-2",
              "display" : "Bloeddruk",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "2680",
          "display" : "zuurstofsaturatie (pulsoximeter)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "9279-1",
              "display" : "Ademhaling",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3963",
          "display" : "hartfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1875",
          "display" : "polsfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33055-1",
              "display" : "Hartslag",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "357",
          "display" : "gewicht patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "560",
          "display" : "lengte patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1272",
          "display" : "Quetelet-index (BMI) patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3017",
          "display" : "lichaamsoppervlakte",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG70-5",
              "display" : "Lichaamsmaten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "1357",
          "display" : "temperatuur patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "LG33052-8",
              "display" : "Temperatuur",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "3963",
          "display" : "hartfrequentie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8867-4",
              "display" : "Hartfrequentie",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1357",
          "display" : "temperatuur",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8310-5",
              "display" : "Temperatuur",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "560",
          "display" : "lengte patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8302-2",
              "display" : "Lengte",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2408",
          "display" : "gewicht patiënt",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "29463-7",
              "display" : "Gewicht",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2680",
          "display" : "zuurstofsaturatie (pulsoximeter)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "59408-5",
              "display" : "Zuurstofsaturatie",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1740",
          "display" : "diastolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8462-4",
              "display" : "Diastolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "1744",
          "display" : "systolische bloeddruk",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8480-6",
              "display" : "Systolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2055",
          "display" : "systolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8480-6",
              "display" : "Systolic",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2056",
          "display" : "diastolic",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "8462-4",
              "display" : "Diastolic",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
