# Epic Provider Type naar SNOMED-CT Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic Provider Type naar SNOMED-CT Mapping**

## ConceptMap: Epic Provider Type naar SNOMED-CT Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/epic-rolcode | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:epictorolcode |

 
Deze ConceptMap representeert de mapping tussen Epic Provider Type (SER#1040) naar een SNOMED-CT code. 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "epic-rolcode",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/epic-rolcode",
  "version" : "1.22.0",
  "name" : "epictorolcode",
  "title" : "Epic Provider Type naar SNOMED-CT Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap representeert de mapping tussen Epic Provider Type (SER#1040) naar een SNOMED-CT code.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "urn:oid:1.2.840.114350.1.13.485.3.7.10.836982.1040",
      "sourceVersion" : "UMCG Epic Non Prod",
      "target" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
      "element" : [
        {
          "code" : "1",
          "display" : "Arts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309343006",
              "display" : "Arts",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2",
          "display" : "Anesthesiemedewerker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309445003",
              "display" : "Anesthesiemedewerker",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "3",
          "display" : "Verpleegkundige",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "106292003",
              "display" : "Verpleegkundige",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "5",
          "display" : "Verloskundige",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "106294002",
              "display" : "Verloskundige",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Physician assistant",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "449161006",
              "display" : "Physician assistant",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Verpleegkundige specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "224571005",
              "display" : "Verpleegkundig specialist",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "102",
          "display" : "Apotheker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "46255001",
              "display" : "Apotheker",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "109",
          "display" : "Co-assistent",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "1255517001",
              "display" : "Co-assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "113",
          "display" : "Arts-assistent",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "405277009",
              "display" : "Arts-assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2503",
          "display" : "Medewerker (medische) administratie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "394572006",
              "display" : "Medisch secretaresse",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2536",
          "display" : "Laboratorium specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "159282002",
              "display" : "Laboratoriumtechnicus",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2537",
          "display" : "Verzorgende",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "73265009",
              "display" : "Verzorgende",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    },
    {
      "source" : "urn:oid:1.2.840.114350.1.13.485.2.7.10.836982.1040",
      "sourceVersion" : "UMCG Epic Prod",
      "target" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
      "element" : [
        {
          "code" : "1",
          "display" : "Arts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309343006",
              "display" : "Arts",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2",
          "display" : "Anesthesiemedewerker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309445003",
              "display" : "Anesthesiemedewerker",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "3",
          "display" : "Verpleegkundige",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "106292003",
              "display" : "Verpleegkundige",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "5",
          "display" : "Verloskundige",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "106294002",
              "display" : "Verloskundige",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Physician assistant",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "449161006",
              "display" : "Physician assistant",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Verpleegkundige specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "224571005",
              "display" : "Verpleegkundig specialist",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "102",
          "display" : "Apotheker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "46255001",
              "display" : "Apotheker",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "109",
          "display" : "Co-assistent",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "1255517001",
              "display" : "Co-assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "113",
          "display" : "Arts-assistent",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "405277009",
              "display" : "Arts-assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2503",
          "display" : "Medewerker (medische) administratie",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "394572006",
              "display" : "Medisch secretaresse",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2536",
          "display" : "Laboratorium specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "159282002",
              "display" : "Laboratoriumtechnicus",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2537",
          "display" : "Verzorgende",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "73265009",
              "display" : "Verzorgende",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    },
    {
      "source" : "urn:oid:1.2.840.114350.1.13.432.2.7.10.836982.1040",
      "sourceVersion" : "MCL Epic Prod",
      "target" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
      "element" : [
        {
          "code" : "1",
          "display" : "Arts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309343006",
              "display" : "Arts",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Physician assistant",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "449161006",
              "display" : "Physician assistant",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Verpleegkundige specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "224571005",
              "display" : "Nurse practitioner",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    },
    {
      "source" : "urn:oid:1.2.840.114350.1.13.432.3.7.10.836982.1040",
      "sourceVersion" : "MCL Epic Non Prod",
      "target" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
      "element" : [
        {
          "code" : "1",
          "display" : "Arts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "309343006",
              "display" : "Medical doctor",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Physician assistant",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "449161006",
              "display" : "Physician assistant",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Verpleegkundige specialist",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "224571005",
              "display" : "Nurse practitioner",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
