# Zorgviewer Host - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Zorgviewer Host**

## CapabilityStatement: Zorgviewer Host 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/ZorgviewerHost | *Version*:1.22.0 |
| Active as of 2023-09-04 | *Computable Name*:ZorgviewerHost |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Zorgviewer Host Bouwblok. 

Benodigde SMART-on-FHIR [scopes](http://hl7.org/fhir/smart-app-launch/1.0.0/scopes-and-launch-context/index.html):

1. user/Patient.read
1. user/Practitioner.read
1. user/PractitionerRole.read

 [Raw OpenAPI-Swagger Definition file](ZorgviewerHost.openapi.json) | [Download](ZorgviewerHost.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "ZorgviewerHost",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/ZorgviewerHost",
  "version" : "1.22.0",
  "name" : "ZorgviewerHost",
  "title" : "Zorgviewer Host",
  "status" : "active",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Zorgviewer Host Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
      "display" : "nl-core-patient"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitioner",
      "display" : "nl-core-practitioner"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitionerrole",
      "display" : "nl-core-practitionerrole"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-organization",
      "display" : "nl-core-organization"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/restful-security-service",
                "code" : "SMART-on-FHIR",
                "display" : "SMART-on-FHIR"
              }
            ],
            "text" : "OAuth2 using SMART-on-FHIR profile (see http://hl7.org/fhir/smart-app-launch/1.0.0/)"
          }
        ]
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "practitioner",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-practitioner",
              "type" : "reference",
              "documentation" : "For getting the AGB roles/specialty (urn:oid:2.16.840.1.113883.2.4.6.7) for a Practitioner, e.g. 0305 Medisch specialisten, orthopedie."
            }
          ]
        },
        {
          "type" : "Organization",
          "profile" : {
            "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-organization"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
