# CodeSysteem Labels - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CodeSysteem Labels**

## ValueSet: CodeSysteem Labels 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ValueSet/CodeSystems | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:CodeSystems |

 
Deze waardelijst bevat de labels voor de gebruikte CodeSystemen 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Changes since version 1.21.0:**

* No changes

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/STU3/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "CodeSystems",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://fhir.hl7.nl/zorgviewer/ValueSet/CodeSystems",
  "version" : "1.22.0",
  "name" : "CodeSystems",
  "title" : "CodeSysteem Labels",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze waardelijst bevat de labels voor de gebruikte CodeSystemen",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:rfc:3986",
        "concept" : [
          {
            "code" : "http://hl7.org/fhir/v3/NullFlavor",
            "display" : "NullFlavor"
          },
          {
            "code" : "http://snomed.info/sct",
            "display" : "SNOMED CT"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.6.96",
            "display" : "SNOMED CT"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.1",
            "display" : "DHD DT",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "Dutch Hospital Data Diagnosethesaurus"
              }
            ]
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.2",
            "display" : "DHD VT",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "Dutch Hospital Data Verrichtingenthesaurus"
              }
            ]
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.120.5.3",
            "display" : "CBV",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "Verrichtingenbestand"
              }
            ]
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.3.27.15.5",
            "display" : "NZa",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "Nederlandse Zorgautoriteit Zorgactiviteiten"
              }
            ]
          },
          {
            "code" : "http://hl7.org/fhir/sid/icd-10-nl",
            "display" : "ICD-10",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "the Dutch version of the International Statistical Classification of Diseases and Related Health Problems, 10th Revision"
              }
            ]
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.6.3.2",
            "display" : "ICD-10",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "the Dutch version of the International Statistical Classification of Diseases and Related Health Problems, 10th Revision"
              }
            ]
          },
          {
            "code" : "http://hl7.org/fhir/sid/icpc-1-nl",
            "display" : "ICPC",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "WHO International Classification of Primary Care"
              }
            ]
          },
          {
            "code" : "http://www.whocc.no/atc",
            "display" : "ATC",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "WHO Anatomical Therapeutic Chemical Classification System"
              }
            ]
          },
          {
            "code" : "http://hl7.org/fhir/sid/ndc",
            "display" : "NDC",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "USA National Drug Code"
              }
            ]
          },
          {
            "code" : "http://hl7.org/fhir/sid/cvx",
            "display" : "CVX",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "CVX codes for vaccines administered"
              }
            ]
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.4.4.10",
            "display" : "PRK",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "G-Standaard Prescriptie Product Kenmerk"
              }
            ]
          },
          {
            "code" : "https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen",
            "display" : "NHG45",
            "designation" : [
              {
                "use" : {
                  "system" : "http://snomed.info/sct",
                  "code" : "900000000000550004",
                  "display" : "Definition"
                },
                "value" : "NHG Tabel 45 Diagnostische Bepalingen"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
