# extension-Meta.source - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **extension-Meta.source**

## Extension: extension-Meta.source 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:extension-Meta.source |

An extension to bring in Meta.source from R4.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [Consent/190c12af-49d4-4553-8009-c816ab622a3e](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md), [Immunization/873](Immunization-873.md), [Immunization/b0a09112-1141-41a5-ab3e-277dd7cf34c4](Immunization-b0a09112-1141-41a5-ab3e-277dd7cf34c4.md), [Immunization/e6-GYWpe6tA541IbVTqmL.KQ0y3yguI2FH9XCaDsG8gI3](Immunization-e6-GYWpe6tA541IbVTqmL.KQ0y3yguI2FH9XCaDsG8gI3.md)...Show 2 more,[Immunization/ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3](Immunization-ekk06V5y.aLipR7luJJbtWUCJul8emhI5g29CotXmMDE3.md)and[Immunization/emmoWnHUUdm1G2gaviFakSiHIeAZOAsB1DSFw4OCaA9Y3](Immunization-emmoWnHUUdm1G2gaviFakSiHIeAZOAsB1DSFw4OCaA9Y3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/extension-Meta.source)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-extension-Meta.source.csv), [Excel](StructureDefinition-extension-Meta.source.xlsx), [Schematron](StructureDefinition-extension-Meta.source.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "extension-Meta.source",
  "url" : "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
  "version" : "1.22.0",
  "name" : "extension-Meta.source",
  "title" : "extension-Meta.source",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "An extension to bring in Meta.source from R4.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "contextType" : "datatype",
  "context" : ["Meta"],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source"
      },
      {
        "id" : "Extension.valueUri:valueUri",
        "path" : "Extension.valueUri",
        "sliceName" : "valueUri",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/bronsysteem-zorgaanbieder"
          }
        }
      }
    ]
  }
}

```
