# VitalSign - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **VitalSign**

## Resource Profile: VitalSign 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/VitalSign | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:VitalSign |

 
Vitale gegevens 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

De volgende zibs vallen min of meer onder het thema vitale gegevens.

| | | |
| :--- | :--- | :--- |
| BgZ, eOverdracht | [ZIB Bloeddruk](https://zibs.nl/wiki/Bloeddruk-v3.1(2017NL)) |   |
| BgZ, eOverdracht | [ZIB Gewicht](https://zibs.nl/wiki/Lichaamsgewicht-v3.1(2017NL)) | GewichtWaarde |
| BgZ, eOverdracht | [ZIB Lengte](https://zibs.nl/wiki/Lichaamslengte-v3.1(2017NL)) | LengteWaarde |
| eOverdracht | [ZIB Temperatuur](https://zibs.nl/wiki/Lichaamstemperatuur-v3.1(2017NL)) | TemperatuurWaarde |
| eOverdracht | [ZIB Ademhaling](https://zibs.nl/wiki/Ademhaling-v3.1(2017NL)) | Ademfrequentie |
| eOverdracht | [ZIB Polsfrequentie](https://zibs.nl/wiki/Polsfrequentie-v3.1(2017NL)) | PolsfrequentieWaarde |
| Huisarts zelfmetingen | [ZIB AlgemeneMeting](https://zibs.nl/wiki/AlgemeneMeting-v3.0(2017NL)) | Uitslag/UitslagWaarde |
| nvt | [ZIB O2Saturatie](https://zibs.nl/wiki/O2Saturatie-v3.1(2017NL)) | SpO2Waarde |
| nvt | [ZIB Hartfrequentie](https://zibs.nl/wiki/Hartfrequentie-v3.1(2017NL)) | HartfrequentieWaarde |

### View Definition

[ViewDefinition voor Vitale Gegevens](ViewDefinition-Vitalegegevens.json)

### UI Wireframe

**Vitale gegevens**

* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Body Height
  * Waarde: 168.1 cm
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body Height
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Pain severity - 0-10 verbal numeric rating [Score] - Reported
  * Waarde: 3 {score}
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**LOINC#72514-3 Pain severity - 0-10 verbal numeric rating [Score] - Reported
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Body Weight
  * Waarde: 85.5 kg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body Weight
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Body mass index (BMI) [Ratio]
  * Waarde: 30.3 kg/m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**LOINC#39156-5 Body mass index (BMI) [Ratio]
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Diastolic Blood Pressure
  * Waarde: 92 mm[Hg]
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**LOINC#8462-4 Diastolic Blood Pressure
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Systolic Blood Pressure
  * Waarde: 113 mm[Hg]
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**LOINC#8480-6 Systolic Blood Pressure
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Heart rate
  * Waarde: 90 /min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8867-4 Heart rate
* ><: +
  * Bron: EPS
  * Datum: 10-11-2024
  * Meting: Respiratory rate
  * Waarde: 14 /min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#9279-1 Respiratory rate
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Body Height
  * Waarde: 168.1 cm
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body Height
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Pain severity - 0-10 verbal numeric rating [Score] - Reported
  * Waarde: 1 {score}
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**LOINC#72514-3 Pain severity - 0-10 verbal numeric rating [Score] - Reported
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Body Weight
  * Waarde: 84.4 kg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body Weight
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Body mass index (BMI) [Ratio]
  * Waarde: 29.9 kg/m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**LOINC#39156-5 Body mass index (BMI) [Ratio]
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Diastolic Blood Pressure
  * Waarde: 88 mm[Hg]
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**LOINC#8462-4 Diastolic Blood Pressure
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Systolic Blood Pressure
  * Waarde: 121 mm[Hg]
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**LOINC#8480-6 Systolic Blood Pressure
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Heart rate
  * Waarde: 96 /min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8867-4 Heart rate
* ><: +
  * Bron: EPS
  * Datum: 5-11-2023
  * Meting: Respiratory rate
  * Waarde: 15 /min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#9279-1 Respiratory rate
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 8-2-2013
  * Meting: Body height
  * Waarde: 183 cm
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body height
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 8-2-2013
  * Meting: Body weight
  * Waarde: 72 kg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body weight
* ><: +
  * Bron: Chipsoft
  * Datum: 7-2-2013
  * Meting: Blood pressure panel with all children optional
  * Waarde: 
  * Waarde componenten: 108/56/73/73 mm[Hg]
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Niet-invasief**MeetLocatie**Linker bovenarm**Meting**LOINC#85354-9 Blood pressure panel with all children optional
* ><: +
  * Bron: Epic-Bundle
  * Datum: 14-8-2025
  * Meting: RR
  * Waarde: 
  * Waarde componenten: 116/67 mm[Hg]
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Non-invasive**MeetLocatie**structuur van linker bovenbeen (lichaamsstructuur)**Meting**LOINC#55284-4 Blood pressure systolic and diastolic
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: RR
  * Waarde: 
  * Waarde componenten: 114/65 mm[Hg]
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Non-invasive**MeetLocatie**gehele rechter onderste extremiteit (lichaamsstructuur)**Meting**LOINC#55284-4 Blood pressure systolic and diastolic
* ><: +
  * Bron: Epic-Bundle
  * Datum: 12-8-2025
  * Meting: RR
  * Waarde: 
  * Waarde componenten: 113/64 mm[Hg]
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Non-invasive**MeetLocatie**gehele linker bovenarm (lichaamsstructuur)**Meting**LOINC#55284-4 Blood pressure systolic and diastolic
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: RR
  * Waarde: 
  * Waarde componenten: 112/63 mm[Hg]
  * Uitvoerder: P Havelaar
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Non-invasive**Meting**LOINC#55284-4 Blood pressure systolic and diastolic
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: RR
  * Waarde: 
  * Waarde componenten: 110/60 mm[Hg]
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Methode**Non-invasive**MeetLocatie**gehele rechter bovenarm (lichaamsstructuur)**Meting**LOINC#55284-4 Blood pressure systolic and diastolic
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: Temperatuur
  * Waarde: 38 Cel
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**LOINC#8310-5 Body temperature
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Temperatuur
  * Waarde: 37 Cel
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**LOINC#8310-5 Body temperature
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: Temperatuur
  * Waarde: 36.4 Cel
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**LOINC#8310-5 Body temperature
* ><: +
  * Bron: Epic-Bundle
  * Datum: 26-8-2025
  * Meting: Polsfrequentie
  * Waarde: 60 /min
  * Waarde componenten: 
  * Uitvoerder: Arts. Interne Geneeskunde, Internist Oncoloog
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs**Toelichting**Opmerking Zorgviewer
* ><: +
  * Bron: Epic-Bundle
  * Datum: 14-8-2025
  * Meting: Polsfrequentie
  * Waarde: 61 /min
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: Polsfrequentie
  * Waarde: 60 /min
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 12-8-2025
  * Meting: Polsfrequentie
  * Waarde: 62 /min
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Polsfrequentie
  * Waarde: 59 /min
  * Waarde componenten: 
  * Uitvoerder: P Havelaar
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: Polsfrequentie
  * Waarde: 58 /min
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Ademfreq.
  * Waarde: 17 /min
  * Waarde componenten: 
  * Uitvoerder: P Havelaar
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: Ademfreq.
  * Waarde: 16 /min
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#8716-3 Vital signs
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: SpO2
  * Waarde: 100 %
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#2708-6 Oxygen saturation in Arterial blood
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: SpO2
  * Waarde: 99 %
  * Waarde componenten: 
  * Uitvoerder: P Havelaar
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#2708-6 Oxygen saturation in Arterial blood
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: SpO2
  * Waarde: 98 %
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**LOINC#2708-6 Oxygen saturation in Arterial blood
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: Lengte
  * Waarde: 171 cm
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body height
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Lengte
  * Waarde: 172 cm
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body height
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Lengte
  * Waarde: 169 cm
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body height
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: Lengte
  * Waarde: 170 cm
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#8302-2 Body height
* ><: +
  * Bron: Epic-Bundle
  * Datum: 13-8-2025
  * Meting: Gewicht
  * Waarde: 71 kg
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body weight
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Gewicht
  * Waarde: 72 kg
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body weight
* ><: +
  * Bron: Epic-Bundle
  * Datum: 25-7-2025
  * Meting: Gewicht
  * Waarde: 69 kg
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body weight
* ><: +
  * Bron: Epic-Bundle
  * Datum: 24-7-2025
  * Meting: Gewicht
  * Waarde: 70 kg
  * Waarde componenten: 
  * Uitvoerder: User. Inpatient, Verpleegkundige
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**LOINC#29463-7 Body weight
* ><: +
  * Bron: Epic
  * Datum: 3-8-2020
  * Meting: Bloeddruk
  * Waarde: 
  * Waarde componenten: 100/60 mm[Hg]
  * Uitvoerder: C Ooms
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**LOINC#85354-9 Blood pressure panel with all children optional
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: gewicht patiënt
  * Waarde: 81 kg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#357 gewicht patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: gewicht patiënt
  * Waarde: 43.535.0 kg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#357 gewicht patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: lengte patiënt
  * Waarde: 1.81 m
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#560 lengte patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: lengte patiënt
  * Waarde: 35.354.00 m
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#560 lengte patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: Quetelet-index (BMI) patiënt
  * Waarde: 24.7 kg/m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#1272 Quetelet-index (BMI) patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: Quetelet-index (BMI) patiënt
  * Waarde: 0 kg/m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#1272 Quetelet-index (BMI) patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: temperatuur patiënt
  * Waarde: 37.3 °C
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**NHG45#1357 temperatuur patiënt
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: temperatuur patiënt
  * Waarde: 23 °C
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**NHG45#1357 temperatuur patiënt**Toelichting**Waarde aangepast van heel veel naar 23
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: roken
  * Waarde: nooit
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#1739 roken
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: diastolische bloeddruk
  * Waarde: 80 mmHg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**NHG45#1740 diastolische bloeddruk
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: diastolische bloeddruk
  * Waarde: 23 mmHg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**NHG45#1740 diastolische bloeddruk
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: systolische bloeddruk
  * Waarde: 125 mmHg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**NHG45#1744 systolische bloeddruk
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: systolische bloeddruk
  * Waarde: 23 mmHg
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Bloeddruk
* ><: 
  * Bron: **Meting**NHG45#1744 systolische bloeddruk
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: polsfrequentie
  * Waarde: 24.342 aantal/min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**NHG45#1875 polsfrequentie**Toelichting**Dit is een opmerking
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: hoe vaak drinken van alcohol (FiveShot1)
  * Waarde: 4 of meer keer per week (score 2)
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#2418 hoe vaak drinken van alcohol (FiveShot1)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: aantal alcoh. dranken op dag (FiveShot2)
  * Waarde: 10 of meer (score 2)
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#2419 aantal alcoh. dranken op dag (FiveShot2)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: geërgerd aan opm. drankgew. (FiveShot3)
  * Waarde: ja (score 1)
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#2420 geërgerd aan opm. drankgew. (FiveShot3)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: schuldig over drankgewoonten (FiveShot4)
  * Waarde: ja (score 1)
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#2421 schuldig over drankgewoonten (FiveShot4)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: 's ochts drinken tegen kater (FiveShot5)
  * Waarde: ja (score 1)
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#2422 's ochts drinken tegen kater (FiveShot5)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: zuurstofsaturatie (pulsoximeter)
  * Waarde: 23.424 %
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Ademhaling
* ><: 
  * Bron: **Meting**NHG45#2680 zuurstofsaturatie (pulsoximeter)
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 21-8-2025
  * Meting: perifeer (enkel) oedeem, pitting
  * Waarde: onduidelijk
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): 
* ><: 
  * Bron: **Meting**NHG45#3007 perifeer (enkel) oedeem, pitting**Toelichting**test bepaling toevoegen
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 7-8-2025
  * Meting: lichaamsoppervlakte
  * Waarde: 2 m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#3017 lichaamsoppervlakte
* ><: +
  * Bron: Sanday-Bundle
  * Datum: 20-8-2025
  * Meting: lichaamsoppervlakte
  * Waarde: 6.538.6 m2
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Lichaamsmaten
* ><: 
  * Bron: **Meting**NHG45#3017 lichaamsoppervlakte
* ><: +
  * Bron: Sanday
  * Datum: 21-3-2024
  * Meting: hartfrequentie (thuismeting)
  * Waarde: 80 aantal/min
  * Waarde componenten: 
  * Uitvoerder: 
  * (Groep): Hartslag
* ><: 
  * Bron: **Meting**NHG45#3963 hartfrequentie (thuismeting)
* ><: +
  * Bron: Epic
  * Datum: 23-8-2019
  * Meting: Temperatuur
  * Waarde: 38 Cel
  * Waarde componenten: 
  * Uitvoerder: S Brouwer
  * (Groep): Temperatuur
* ><: 
  * Bron: **Meting**LOINC#8310-5 Body temperature

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `effectiveDateTime`
  * ?: `dateTime`
  * ?: *DatumTijd
  * ?: 
* UITKLAPVELD: Meting
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: MetingNaam
  * ?: 
* UITKLAPVELD: Waarde
  * ?: `valueQuantity.value.toString()+' '+valueQuantity.unit | valueString | valueCodeableConcept.coding.display`
  * ?: `string`
  * ?: Uitslag/Waarde
  * ?: 
* UITKLAPVELD: Waarde componenten
  * ?: `component.valueQuantity.value.select(toString()).join('/')+' '+component[0].valueQuantity.unit`
  * ?: `string`
  * ?: *Waarde
  * ?: 
* UITKLAPVELD: Uitvoerder
  * ?: `performer.display`
  * ?: `string`
  * ?: Auteur
  * ?: 
* UITKLAPVELD: +Methode
  * ?: `method.text`
  * ?: `string`
  * ?: *Type
  * ?: 
* UITKLAPVELD: +MeetLocatie
  * ?: `iif(bodySite.text='Body Site',bodySite.coding[1].display,bodySite.text)`
  * ?: `string`
  * ?: MeetLocatie
  * ?: 
* UITKLAPVELD: +Meting
  * ?: `code.coding.where(system='http://loinc.org').select('LOINC#' + code + ' ' + display)`
  * ?: `string`
  * ?: MetingNaam
  * ?: Meerdere codes mogelijk.Ignore NullFlavor.Lookup system label middels`<terminologie-base>/CodeSystem?url=<system>`en gebruik dan`CodeSystem.title`
* UITKLAPVELD: +Meting
  * ?: `code.coding.where(system='https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen').select('NHG45#' + code + ' ' + display)`
  * ?: `string`
  * ?: MetingNaam
  * ?: 
* UITKLAPVELD: +Toelichting
  * ?: `comment | note.text`
  * ?: `string`
  * ?: Toelichting
  * ?: **LET OP:**`note.text`is een FHIR R4 veld
* UITKLAPVELD: MARKERING
* UITKLAPVELD: (Groep)
  * ?: `code.coding.where(system='http://loinc.org' and code!='8716-3').translate('vital-signs-groups').target[0].display | code.coding.where(system='https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen').translate('vital-signs-groups').target[0].display`
  * ?: `code`
  * ?: nvt
  * ?: Lookup LOINC 'groep' code middels`<terminologie-base>[/ConceptMap/vital-signs-groups](ConceptMap-vital-signs-groups.md)$translate?code=<code>`Gebruik deze om de regels te groeperen.Verberg regels die**GEEN**groep hebben.

### Zoeken naar codes

* [LOINC](https://terminologie.nictiz.nl/art-decor/loinc) - `system=http://loinc.org`
* [NHG Tabel 45 Diagnostische Bepalingen Diagnostisch](https://bepalingen.nhg.org/labcodes/determinations?q%5Bapplication_kind_cont%5D=D) `system=https://referentiemodel.nhg.org/tabellen/nhg-tabel-45-diagnostische-bepalingen`

### Request

N.B. Eerste request is optimaal en wordt ondersteund door Epic en Sanday. De andere requests zijn de "officiele" BgZ requests en zijn nodig voor uitvragen van Zorgplatform.

1. Opvragen (search) vitale gegevens`GET <ontsluiten-bronsysteem-base>/Observation?patient=<fhir_patient_id>&category=vital-signs`
1. Opvragen (search) bloeddruk (BgZ)`GET <ontsluiten-bronsysteem-base>/Observation?patient=<fhir_patient_id>&code=http://loinc.org|85354-9`
1. Opvragen (search) gewicht (BgZ)`GET <ontsluiten-bronsysteem-base>/Observation?patient=<fhir_patient_id>&code=http://loinc.org|29463-7`
1. Opvragen (search) lengte (BgZ)`GET <ontsluiten-bronsysteem-base>/Observation?patient=<fhir_patient_id>&code=http://loinc.org|8302-2,http://loinc.org|8306-3,http://loinc.org|8308-9`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/VitalSign)

**Changes since version 1.21.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-VitalSign.csv), [Excel](StructureDefinition-VitalSign.xlsx), [Schematron](StructureDefinition-VitalSign.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "VitalSign",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/VitalSign",
  "version" : "1.22.0",
  "name" : "VitalSign",
  "title" : "VitalSign",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Vitale gegevens",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Mapping"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.info/sct",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.comment",
        "path" : "Observation.comment",
        "mustSupport" : true
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "mustSupport" : true
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
