# TreatmentDirective - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **TreatmentDirective**

## Resource Profile: TreatmentDirective 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:TreatmentDirective |

 
Advanced Care Planning (ACP) Behandelaanwijzingen (Consent) 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

> 
* N.B. "Geverifieerd" en "Geverifieerd bij" wel gewenst vanuit FMS, maar niet beschikbaar in alle huidige configuraties en "echte" voorbeeld data.
* Op dit moment zijn alleen de ACP Behandelwensen deel (de BehandelAanwijzing zib) in scope. Deze specificering van de zib BehandelAanwijzing is te vinden in dit [profile](#profile).

### Zorginformatiebouwsteen

[ZIB BehandelAanwijzing](https://zibs.nl/wiki/BehandelAanwijzing-v3.1(2017NL))

### FMS Adequate Registratie

Als bron voor de must-support flags is gebruikt: [Fit-gap analyse behandelaanwijzing](https://amigo.nictiz.nl/uploads/7d857f79-4b79-4732-a1dd-2756bf4cdd24/fit_gap_analyse_Behandelaanwijzing.pdf)

### Behandelgrenzen van de Advance Care Planning (ACP)

**Synoniem = Proactieve zorgplanning**

Eerder in datasets onder het kopje [Advanced Care Planning (ACP)](datasets.md#advanced-care-planning) is uitgelegd waar het formulier en de dataset uit bestaat. Vanuit de landelijke organisatie rondom palliatieve zorg is er een aanvulling nodig van de BehandelingCodelijst, komende uit de zib BehandelAanwijzing. Toegevoegd zijn drie nieuwe categorieen met SNOMED CT codering. Deze lijst kun je vinden op [ACP TreatmentCodelist](ValueSet-ACPTreatmentCodelist.md) pagina.

### View Definition

[ViewDefinition voor Behandelaanwijzingen](ViewDefinition-Behandelaanwijzingen.json)

### UI Wireframe

**Behandelaanwijzingen**

* ><: +
  * Bron: Chipsoft
  * Datum: 30-9-2022
  * Behandeling: Artificial respiration (procedure)
  * Behandeling toegestaan: Ja, maar met beperkingen
  * Beperkingen: Toelichting: Eerst overleg met echtgenote
  * Geverifieerd bij: 
  * (status): active
* ><: 
  * Bron: **Categorie**Treatment instructions
* ><: +
  * Bron: Epic
  * Datum: 22-3-2022
  * Behandeling: kunstmatige beademing (verrichting)
  * Behandeling toegestaan: Ja, maar met beperkingen
  * Beperkingen: Eerst overleg met echtgenote
  * Geverifieerd bij: patiënt (persoon)
  * (status): active
* ><: 
  * Bron: **Categorie**Advance Directive & Vastgelegd
* ><: +
  * Bron: Nexus
  * Datum: 5-5-2023
  * Behandeling: Kunstmatige beademing
  * Behandeling toegestaan: Behandeling niet toegestaan en/of wenselijk
  * Beperkingen: 
  * Geverifieerd bij: 
  * (status): active
* ><: 
  * Bron: **Toelichting**testje**Categorie**Behandelingsinstructies (artefact opnemen)

### Kolom Definities

* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `period.start`
  * ?: `dateTime`
  * ?: BeginDatum
  * ?: Kunnen vage datums zijn.
* UITKLAPVELD: Behandeling
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Treatment').valueCodeableConcept.coding[0].display`
  * ?: `string`
  * ?: Behandeling
  * ?: 
* UITKLAPVELD: Behandeling toegestaan
  * ?: `modifierExtension.where(url='http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-TreatmentPermitted').valueCodeableConcept.coding.display`
  * ?: `string`
  * ?: BehandelingToegestaan
  * ?: Zie UI schets voor icon mapping. N.B. obv coding.code
* UITKLAPVELD: Beperkingen
  * ?: `except.extension('http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Restrictions').value`
  * ?: `string`
  * ?: Beperkingen
  * ?: 
* UITKLAPVELD: Geverifieerd bij
  * ?: `extension('http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Verification').extension('VerifiedWith').valueCodeableConcept.text.join(' & ')`
  * ?: `string`
  * ?: GeverifieerdBij
  * ?: 
* UITKLAPVELD: +Toelichting
  * ?: `extension.where(url='http://nictiz.nl/fhir/StructureDefinition/Comment').valueString`
  * ?: `string`
  * ?: Toelichting
  * ?: 
* UITKLAPVELD: +Categorie
  * ?: `category.coding.display.join(' & ')`
  * ?: `string`
  * ?: nvt
  * ?: 
* UITKLAPVELD: MARKERING
* UITKLAPVELD: (status)
  * ?: `status`
  * ?: `code`
  * ?: nvt
  * ?: 

### User-Interface Mockup

**! Belangrijk dat de UI Schets van Behandelaanwijzing en de UI Schets van Wilsverklaring in één scherm te tonen.**

Een schets van het scherm met labels en sortering informatie:

### Gerelateerde Mapping

> Voor implementatie in VIPLive, die zib 2020 gebasseerd is, zijn mappings gedefinieerd tussen de 2017 zib versie en de 2020 zib versie. Deze mappings zijn voorgelegd aan het Nictiz zib-centrum en zij hebben deze voorlopig geaccepteerd terwijl zij verder werken aan de officiele transformaties.
* equal betekent 100% gelijk
* equivalent betekent ongeveer gelijk

* [ConceptMap Behandelaanwijzing 2017 en Behandelaanwijzing2 2020](ConceptMap-behandelaanwijzing-2017-2020.md)

### Request

1. Opvragen (search) behandelaanwijzingen`GET <ontsluiten-bronsysteem-base>/Consent?patient=<fhir_patient_id>&category=http://snomed.info/sct|11291000146105`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Examples for this Profile: [Consent/190c12af-49d4-4553-8009-c816ab622a3e](Consent-190c12af-49d4-4553-8009-c816ab622a3e.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/TreatmentDirective)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TreatmentDirective.csv), [Excel](StructureDefinition-TreatmentDirective.xlsx), [Schematron](StructureDefinition-TreatmentDirective.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TreatmentDirective",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective",
  "version" : "1.22.0",
  "name" : "TreatmentDirective",
  "title" : "TreatmentDirective",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Advanced Care Planning (ACP) Behandelaanwijzingen (Consent)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-treatmentdirective-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/TreatmentDirective-v3.1(2017EN)",
      "name" : "HCIM TreatmentDirective-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-treatmentdirective-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/TreatmentDirective-v3.0(2016EN)",
      "name" : "HCIM TreatmentDirective-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-treatmentdirective-v1.0.1-2015EN",
      "uri" : "https://zibs.nl/wiki/TreatmentDirective-v1.0.1(2015EN)",
      "name" : "HCIM TreatmentDirective-v1.0.1(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.extension:verification",
        "path" : "Consent.extension",
        "sliceName" : "verification",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Consent.extension:verification.extension:VerifiedWith",
        "path" : "Consent.extension.extension",
        "sliceName" : "VerifiedWith",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Consent.extension:verification.extension:VerifiedWith.valueCodeableConcept:valueCodeableConcept",
        "path" : "Consent.extension.extension.valueCodeableConcept",
        "sliceName" : "valueCodeableConcept",
        "mustSupport" : true
      },
      {
        "id" : "Consent.extension:comment",
        "path" : "Consent.extension",
        "sliceName" : "comment",
        "mustSupport" : true
      },
      {
        "id" : "Consent.extension:treatment",
        "path" : "Consent.extension",
        "sliceName" : "treatment",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Consent.extension:treatment.valueCodeableConcept:valueCodeableConcept",
        "path" : "Consent.extension.valueCodeableConcept",
        "sliceName" : "valueCodeableConcept",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "The medical treatment to which the treatment instruction applies.",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/ACPTreatmentCodelist"
          }
        }
      },
      {
        "id" : "Consent.modifierExtension:treatmentPermitted",
        "path" : "Consent.modifierExtension",
        "sliceName" : "treatmentPermitted",
        "mustSupport" : true
      },
      {
        "id" : "Consent.period",
        "path" : "Consent.period",
        "mustSupport" : true
      },
      {
        "id" : "Consent.period.start",
        "path" : "Consent.period.start",
        "mustSupport" : true
      },
      {
        "id" : "Consent.except.extension:restrictions",
        "path" : "Consent.except.extension",
        "sliceName" : "restrictions",
        "max" : "1",
        "mustSupport" : true
      }
    ]
  }
}

```
