# Probleemlijst - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Probleemlijst**

## Resource Profile: Probleemlijst ( Abstract ) 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Probleemlijst | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Probleemlijst |

 
Probleemlijst abstracte samenstelling voor het documenteren van de combinatie van Condition en Conditions bij EpisodeOfCare. 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

* [ZIB Probleem](StructureDefinition-Condition.md#zorginformatiebouwsteen)
* [ZIB EpisodeOfCare/Condition](StructureDefinition-EpisodeOfCare.md#zorginformatiebouwsteen)

### View Definition

[ViewDefinition voor Probleemlijst](ViewDefinition-Probleemlijst.json)

### UI Wireframe

**Problemen (incl. diagnosen)**

* ><: +
  * Bron: EPS
  * Datum: 21-1-2020
  * Diagnose: Osteoarthritis of knee
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#239873007 Osteoarthritis of knee (disorder)
* ><: +
  * Bron: EPS
  * Datum: 4-2-2014
  * Diagnose: Fibromyalgia
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#203082005 Fibromyalgia (disorder)
* ><: +
  * Bron: EPS
  * Datum: 29-1-2002
  * Diagnose: Chronic sinusitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#40055000 Chronic sinusitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 20-4-2022
  * Diagnose: Acute viral pharyngitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#195662009 Acute viral pharyngitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 21-2-2020
  * Diagnose: Viral sinusitis
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#444814009 Viral sinusitis (disorder)
* ><: +
  * Bron: EPS
  * Datum: 9-6-2019
  * Diagnose: Miscarriage in first trimester
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#19169002 Miscarriage in first trimester (disorder)
* ><: +
  * Bron: EPS
  * Datum: 9-6-2019
  * Diagnose: Complete miscarriage
  * Status: 
  * (regelkleur): 
* ><: 
  * Bron: **Diagnose**SNOMED CT#156073000 Complete miscarriage (disorder)
* ><: +
  * Bron: Chipsoft
  * Datum: 1-1-2001
  * Diagnose: fractuur van pols
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**NullFlavor#OTH other**Toelichting**Gevallen op kunstijsbaan.
* ><: +
  * Bron: Epic-note
  * Datum: 23-2-2023
  * Diagnose: posttraumatische stressstoornis (incl. de posttraumatische-stressstoornis bij ki...
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICD-10#F43.1**Toelichting**2022-02: ziekte van Crohn2021-07: Complicatie ANPY infectie lokaal2021-03: z...
* ><: +
  * Bron: Epic
  * Datum: 16-8-2012
  * Diagnose: fractuur van onderste extremiteit
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICD-10#T12.0
* ><: +
  * Bron: Nexus
  * Datum: 1-1-2001
  * Diagnose: fractuur van pols
  * Status: Niet actueel
  * (regelkleur): inactive
* ><: 
  * Bron: **Diagnose**SNOMED CT#31641000146105 fractuur van pols**Toelichting**Gevallen op kunstijsbaan
* ><: ><
  * Bron: Bron
  * Datum: Datum
  * Diagnose: Diagnose
  * Status: Status
  * (regelkleur): (regelkleur)
* ><: +
  * Bron: Sanday-US315638
  * Datum: 7-8-2025
  * Diagnose: Hernia inguinalis
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICPC#D89 Hernia inguinalis
* ><: +
  * Bron: Sanday-US315638
  * Datum: 1-4-2025
  * Diagnose: Keelpijn
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICPC#R21.01 Keelpijn
* ><: +
  * Bron: Sanday-US315638
  * Datum: 21-8-2025
  * Diagnose: Lokale infectie vinger/teen/paronychia
  * Status: Actueel
  * (regelkleur): active
* ><: 
  * Bron: **Diagnose**ICPC#S09 Lokale infectie vinger/teen/paronychia
* ><: +
  * Bron: Sanday-US315638
  * Datum: 13-2-2025
  * Diagnose: Maagpijn
  * Status: Niet actueel
  * (regelkleur): finished
* ><: 
  * Bron: **Diagnose**ICPC#D02 Maagpijn

### Kolom Definities

* UITKLAPVELD: *Condition*
* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `onsetPeriod.start | onsetDateTime`
  * ?: `dateTime`
  * ?: ProbleemBeginDatum
  * ?: Laat één datum zien als de`.onsetDateTime`en`.onsetPeriod`hetzelfde zijn
* UITKLAPVELD: Diagnose
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: ProbleemNaam
  * ?: 
* UITKLAPVELD: Status
  * ?: `clinicalStatus.lookup('ProbleemStatus').display`
  * ?: `code`
  * ?: ProbleemStatus
  * ?: Zie voor labels:[ValueSet-ProbleemStatus](ValueSet-ProbleemStatus.md)
* UITKLAPVELD: +Diagnose
  * ?: `code.coding[0].select(system.lookup('CodeSystems').display+'#' + code + ' ' + iif(exists(display),display,''))`
  * ?: `string`
  * ?: ProbleemNaam
  * ?: Meerdere codes mogelijk.Ignore NullFlavor.Lookup system label middels`<terminologie-base>/CodeSystem?url=<.system>`en gebruik dan`.display`Zie voor labels:[ValueSet-CodeSystems](ValueSet-CodeSystems.md)
* UITKLAPVELD: +Toelichting
  * ?: `note.text`
  * ?: `string`
  * ?: Toelichting
  * ?: 
* UITKLAPVELD: MARKERING
* UITKLAPVELD: (regelkleur)
  * ?: `clinicalStatus`
  * ?: `code`
  * ?: ProbleemStatus
  * ?: Actueel (`active,recurrence`) = groene rijen, dikgedruktNiet actueel (`inactive,remission,resolved`) = grijze rijen
* UITKLAPVELD: *EpisodeOfCare*
* UITKLAPVELD: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* UITKLAPVELD: Datum
  * ?: `diagnosis.condition.resolve().select(onsetPeriod.start | onsetDateTime)`
  * ?: `dateTime`
  * ?: Probleem/ ProbleemBeginDatum
  * ?: Laat één datum zien als de`.onsetDateTime`en`.onsetPeriod`hetzelfde zijn
* UITKLAPVELD: Diagnose
  * ?: `diagnosis.condition.resolve().select(code.text | code.coding[0].display)`
  * ?: `string`
  * ?: Probleem/ ProbleemNaam
  * ?: 
* UITKLAPVELD: Status
  * ?: `status.lookup('ProbleemStatus').display`
  * ?: `code`
  * ?: nvt
  * ?: Zie voor labels:[ValueSet-ProbleemStatus](ValueSet-ProbleemStatus.md)
* UITKLAPVELD: UITKLAPVELD
* UITKLAPVELD: +Diagnose
  * ?: `diagnosis.condition.resolve().select(code.coding[0].select(system.lookup('CodeSystems')[0].display+'#' + code + ' ' + iif(exists(display),display,'')))`
  * ?: `string`
  * ?: Probleem/ ProbleemNaam
  * ?: Meerdere codes mogelijk.Ignore NullFlavor.Lookup system label middels`<terminologie-base>/CodeSystem?url=<.system>`en gebruik dan`.display`Zie voor labels:[ValueSet-CodeSystems](ValueSet-CodeSystems.md)
* UITKLAPVELD: +Toelichting
  * ?: `diagnosis.condition.resolve().note.text`
  * ?: `string`
  * ?: Probleem/ Toelichting
  * ?: 
* UITKLAPVELD: MARKERING
* UITKLAPVELD: (regelkleur)
  * ?: `status`
  * ?: `code`
  * ?: nvt
  * ?: Actueel (`active`) = groene rijen, dikgedruktNiet actueel (`finished`) = grijze rijen

### Requests

Er is geen request waarmee je beide resources in 1 keer kan opvragen. Je moet hiervoor dus een request doen per resource.

* Zie [Condition](StructureDefinition-Condition.md#request) en [EpisodeOfCare](StructureDefinition-EpisodeOfCare.md#request)

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Probleemlijst)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Probleemlijst.csv), [Excel](StructureDefinition-Probleemlijst.xlsx), [Schematron](StructureDefinition-Probleemlijst.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Probleemlijst",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Probleemlijst",
  "version" : "1.22.0",
  "name" : "Probleemlijst",
  "title" : "Probleemlijst",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Probleemlijst abstracte samenstelling voor het documenteren van de combinatie van Condition en Conditions bij EpisodeOfCare.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "short" : "searchset",
        "fixedCode" : "searchset"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Bundle.entry:Condition",
        "path" : "Bundle.entry",
        "sliceName" : "Condition",
        "short" : "Condition"
      },
      {
        "id" : "Bundle.entry:Condition.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:Condition.resource",
        "path" : "Bundle.entry.resource",
        "comment" : "Probleem",
        "min" : 1,
        "type" : [
          {
            "code" : "Condition",
            "profile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition"
          }
        ]
      },
      {
        "id" : "Bundle.entry:EpisodeOfCare",
        "path" : "Bundle.entry",
        "sliceName" : "EpisodeOfCare",
        "short" : "EpisodeOfCare"
      },
      {
        "id" : "Bundle.entry:EpisodeOfCare.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry:EpisodeOfCare.resource",
        "path" : "Bundle.entry.resource",
        "comment" : "Zorgepisode",
        "min" : 1,
        "type" : [
          {
            "code" : "EpisodeOfCare",
            "profile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/EpisodeOfCare"
          }
        ]
      }
    ]
  }
}

```
