# PractitionerRole - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole**

## Resource Profile: PractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:PractitionerRole |

 
De rollen van de Zorgverlener 

### Request

1. Opvragen (search) rollen bij een specifieke zorgverlener`GET <zorgverlener-directory-base>/PractitionerRole/?practitioner=<Practitioner.id>`
1. Opvragen (search) rollen bij een zorgverlener adhv identifier`GET <zorgverlener-directory-base>/PractitionerRole/?identifier=<AGB/BIG>`

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md), [Zorgverlener Directory](CapabilityStatement-ZorgverlenerDirectory.md) and [Zorgviewer Host](CapabilityStatement-ZorgviewerHost.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/PractitionerRole)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PractitionerRole.csv), [Excel](StructureDefinition-PractitionerRole.xlsx), [Schematron](StructureDefinition-PractitionerRole.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PractitionerRole",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole",
  "version" : "1.22.0",
  "name" : "PractitionerRole",
  "title" : "PractitionerRole",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "De rollen van de Zorgverlener",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-contactinformation-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.0(2017EN)",
      "name" : "HCIM ContactInformation-v1.0(2017EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-contactinformation-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.0(2016EN)",
      "name" : "HCIM Patient-v3.0(2016EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    },
    {
      "identity" : "hcim-contactinformation-v2.0.1-2015EN",
      "uri" : "https://zibs.nl/wiki/Patient-v2.0.1(2015EN)",
      "name" : "HCIM Patient-v2.0.1(2015EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitionerrole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "constraint" : [
          {
            "key" : "zv-prr-1",
            "severity" : "error",
            "human" : "PractitionerRole Specialty COD016 Vektiz AGB medische specialismen code SHOULD be present.",
            "expression" : "identifier.where(system='urn:oid:2.16.840.1.113883.2.4.6.7')",
            "xpath" : "/f:identifier/f:system='urn:oid:2.16.840.1.113883.2.4.6.7'"
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "definition" : "Zie [ConceptMap-epic-rolcode](ConceptMap-epic-rolcode.html) en [ConceptMap-rolcodenl](ConceptMap-rolcodenl.html)",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "A custom code defined by a concept map.",
          "valueSetReference" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist"
          }
        }
      },
      {
        "id" : "PractitionerRole.specialty.coding:SpecialtyAGB",
        "path" : "PractitionerRole.specialty.coding",
        "sliceName" : "SpecialtyAGB",
        "mustSupport" : true
      }
    ]
  }
}

```
