# Patient - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient**

## Resource Profile: Patient 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Patient |

 
Patient 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Patient](https://zibs.nl/wiki/Patient-v3.1(2017NL))

### Patient.name algoritme

Bovenop constraint **zv-pat-1**:

1. als`name[].use`gebruik dan de`name[use="official"]`, anders de 1ste`name[0]`
1. als`name[].text`gebruik die, anders concatenate de 1ste`name[].given[0]`met de`name[].family`

### Requests

1. Opvragen (search) naar patient op basis van de BSN`GET <bronsysteem-ontsluiting-base/Patient?identifier=<BSN>`
1. Of opvragen (search) middels POST, zie:[FHIR STU3 http search](https://hl7.org/fhir/STU3/http.html#search)`POST <bronsysteem-ontsluiting-base/Patient/_search``Content-Type: application/x-www-form-urlencoded``identifier=<BSN>`
1. Of (Sanday) opvragen (match) middels POST, zie:[FHIR STU3 operation-patient-match](https://hl7.org/fhir/STU3/operation-patient-match.html)`POST <bronsysteem-ontsluiting-base/Patient/$match`

```
 {
   "resourceType": "Patient",
   "identifier": [ {
     "use": "official",
     "system": "http://fhir.nl/fhir/NamingSystem/bsn",
     "value": "123456789"
   } ]
 }

```


1. Opvragen (read) patient op basis van de fhir_patient_id`GET <ontsluiten-bronsysteem-base>/Patient/<fhir_patient_id>`

### Response

1. Bundle met 1 PatientDit is de gewenste situatie.
1. Bundle met meer dan 1 PatientDit kan gebeuren na een SEH opname als de patient nog niet samengevoegd is.
1. Bundle zonder patienten of een HTTP Response 401/404Dit gebeurt als de patient GEEN toestemming heeft gegeven of de patient simpelweg niet bestaat bij de bevraagde organisatie.

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Refer to this Profile: [ToestemmingConsent](StructureDefinition-ToestemmingConsent.md)
* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem - Sanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md), [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md) and [Zorgviewer Host](CapabilityStatement-ZorgviewerHost.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Patient)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient.csv), [Excel](StructureDefinition-Patient.xlsx), [Schematron](StructureDefinition-Patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient",
  "version" : "1.22.0",
  "name" : "Patient",
  "title" : "Patient",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Patient",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-patient-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.1(2017EN)",
      "name" : "HCIM Patient-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-maritalstatus-v3.0-2017EN",
      "uri" : "https://zibs.nl/wiki/MaritalStatus-v3.0(2017EN)",
      "name" : "HCIM MaritalStatus-v3.0(2017EN)"
    },
    {
      "identity" : "hcim-contactperson-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/ContactPerson-v3.1(2017EN)",
      "name" : "HCIM ContactPerson-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-healthcareprovider-v3.1.1-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.1.1(2017EN)",
      "name" : "HCIM HealthcareProvider-v3.1.1(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-nationality-v3.0-2017EN",
      "uri" : "https://zibs.nl/wiki/Nationality-v3.0(2017EN)",
      "name" : "HCIM Nationality-v3.0(2017EN)"
    },
    {
      "identity" : "hcim-payer-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Payer-v3.1(2017EN)",
      "name" : "HCIM Payer-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-contactinformation-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.0(2017EN)",
      "name" : "HCIM ContactInformation-v1.0(2017EN)",
      "comment" : "ContactInformation has become an independent information model as of release 2017 of the HCIMs."
    },
    {
      "identity" : "hcim-languageproficiency-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/LanguageProficiency-v3.1(2017EN)",
      "name" : "HCIM LanguageProficiency-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-freedomrestrictingmeasures-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/FreedomRestrictingMeasures-v3.1(2017EN)",
      "name" : "HCIM FreedomRestrictingMeasures-v3.1(2017EN)",
      "comment" : "Concerns only LegalStatus concept. This will become an independent information model as of release 2018 of the HCIMs."
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-familysituation-v3.0-2017EN",
      "uri" : "https://zibs.nl/wiki/FamilySituation-v3.0(2017EN)",
      "name" : "HCIM FamilySituation-v3.0(2017EN)"
    },
    {
      "identity" : "hcim-lifestance-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/LifeStance-v3.1(2017EN)",
      "name" : "HCIM LifeStance-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-patient-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Patient-v3.0(2016EN)",
      "name" : "HCIM Patient-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-maritalstatus-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/MaritalStatus-v3.0(2016EN)",
      "name" : "HCIM MaritalStatus-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-contactperson-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/ContactPerson-v3.0(2016EN)",
      "name" : "HCIM ContactPerson-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthcareprovider-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v3.0(2016EN)",
      "name" : "HCIM HealthcareProvider-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-nationality-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Nationality-v3.0(2016EN)",
      "name" : "HCIM Nationality-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-payer-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Payer-v3.0(2016EN)",
      "name" : "HCIM Payer-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-familysituation-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/FamilySituation-v3.0(2016EN)",
      "name" : "HCIM FamilySituation-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-patient-v2.0.1-2015EN",
      "uri" : "https://zibs.nl/wiki/Patient-v2.0.1(2015EN)",
      "name" : "HCIM Patient-v2.0.1(2015EN)"
    },
    {
      "identity" : "hcim-maritalstatus-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/MaritalStatus-v1.2.1(2015EN)",
      "name" : "HCIM MaritalStatus-v1.2.1(2015EN)"
    },
    {
      "identity" : "hcim-contactperson-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/ContactPerson-v1.2(2015EN)",
      "name" : "HCIM ContactPerson-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-healthcareprovider-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthcareProvider-v1.2(2015EN)",
      "name" : "HCIM HealthcareProvider-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    },
    {
      "identity" : "hcim-nationality-v2.0-2015EN",
      "uri" : "https://zibs.nl/wiki/Nationality-v2.0(2015EN)",
      "name" : "HCIM Nationality-v2.0(2015EN)"
    },
    {
      "identity" : "hcim-payer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/Payer-v1.2(2015EN)",
      "name" : "HCIM Payer-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-familysituation-v1.0-2015EN",
      "uri" : "https://zibs.nl/wiki/FamilySituation-v1.0(2015EN)",
      "name" : "HCIM FamilySituation-v1.0(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.identifier:BSN",
        "path" : "Patient.identifier",
        "sliceName" : "BSN",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "constraint" : [
          {
            "key" : "zv-pat-1",
            "severity" : "error",
            "human" : "Either Patient.name.given and/or Patient.name.family and/or Patient.name.text SHALL be present.",
            "expression" : "(family.exists() or given.exists() or text.exists())",
            "xpath" : "/f:name/f:family or /f:name/f:given or /f:name/f:text"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice",
                "valueBoolean" : true
              }
            ],
            "key" : "zv-pat-2",
            "severity" : "warning",
            "human" : "To be usable for a wide range of internationally available applications, the Patient.name.text SHOULD be present.",
            "expression" : "text.exists()",
            "xpath" : "/f:name/f:text"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "mustSupport" : true
      },
      {
        "id" : "Patient.deceased[x]",
        "path" : "Patient.deceased[x]",
        "mustSupport" : true
      },
      {
        "id" : "Patient.managingOrganization",
        "path" : "Patient.managingOrganization",
        "mustSupport" : true
      }
    ]
  }
}

```
