# Medication - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication**

## Resource Profile: Medication 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medication | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Medication |

 
Medicatie 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB FarmaceutischProduct](https://zibs.nl/wiki/FarmaceutischProduct-v2.0(2017NL))

**Usages:**

* Refer to this Profile: [MedicationAgreement](StructureDefinition-MedicationRequest.md) and [MedicationUse](StructureDefinition-MedicationStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Medication)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Medication.csv), [Excel](StructureDefinition-Medication.xlsx), [Schematron](StructureDefinition-Medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Medication",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Medication",
  "version" : "1.22.0",
  "name" : "Medication",
  "title" : "Medication",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Medicatie",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-pharmaceuticalproduct-v2.0-2017EN",
      "uri" : "https://zibs.nl/wiki/PharmaceuticalProduct-v2.0(2017EN)",
      "name" : "HCIM PharmaceuticalProduct-v2.0(2017EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Product",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.form",
        "path" : "Medication.form",
        "mustSupport" : true
      },
      {
        "id" : "Medication.form.coding",
        "path" : "Medication.form.coding",
        "mustSupport" : true
      },
      {
        "id" : "Medication.form.coding.display",
        "path" : "Medication.form.coding.display",
        "mustSupport" : true
      }
    ]
  }
}

```
