# Vaccination - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vaccination**

## Resource Profile: Vaccination 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/Immunization | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:Vaccination |

 
Vaccinatie (Immunization) 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Vaccinaties](https://zibs.nl/wiki/Vaccinatie-v3.1(2017NL))

### View Definition

[ViewDefinition voor Vaccinaties](ViewDefinition-Immunization.json)

### UI Wireframe

**Vaccinaties**

* ><: +
  * Bron: EPS
  * Datum: 
  * Product: Influenza virus antigen only vaccine product
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: EPS
  * Datum: 
  * Product: SARS-CoV-2 mRNA vaccine
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: EPS
  * Datum: 
  * Product: Hepatitis A virus antigen only vaccine product
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: EPS
  * Datum: 
  * Product: Clostridium tetani toxoid antigen adsorbed only vaccine product
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft
  * Datum: 5-3-1999
  * Product: HEPATITIS-A-VACCIN HAVRIX JR WSP 0,5ML (1440E/ML)
  * Toelichting: Bezoek aan Guatemala
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 2-8-2021
  * Product: COVID-19 Vaccin (Type Algemeen)
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Datum: 5-3-1999
  * Product: hepatitis-a-vaccin
  * Toelichting: Bezoek aan Guatemala.
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 29-7-2019
  * Product: Bof-/Mazelen-/Rubellavaccin
  * Toelichting: 
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 25-3-2021
  * Product: COVID-19 Vaccin (Spikevax, Moderna)
  * Toelichting: 
* ><: 
  * Bron: 

### Kolom Definities

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Bron | `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri` | `string` | nvt | Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name` |
| Datum | `date` | `dateTime` | VaccinatieDatum |  |
| Product | `iif(exists(vaccineCode.text),vaccineCode.text,vaccineCode.coding.display)` | `string` | ProductCode |  |
| Toelichting | `note.text` | `string` | Toelichting |  |

### Gebruikte waardelijsten

* ATC (Nexus) - `system=http://www.whocc.no/atc`
* NDC (Epic) - `system=http://hl7.org/fhir/sid/ndc`
* CVX (Epic) - `system=http://hl7.org/fhir/sid/cvx`
* G-Standaard Voorschrijfproducten (PRK) (Chipsoft) - `system=urn:oid:2.16.840.1.113883.2.4.4.10`

### Request

1. Opvragen (search) vaccinaties`GET <ontsluiten-bronsysteem-base>/Immunization?patient=<fhir_patient_id>&status=completed`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/Immunization)

**Changes since version 1.21.0:**

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Immunization.csv), [Excel](StructureDefinition-Immunization.xlsx), [Schematron](StructureDefinition-Immunization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Immunization",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Immunization",
  "version" : "1.22.0",
  "name" : "Vaccination",
  "title" : "Vaccination",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Vaccinatie (Immunization)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-vaccination-v3.1-2017EN",
      "uri" : "https://zibs.nl/wiki/Vaccination-v3.1(2017EN)",
      "name" : "HCIM Vaccination-v3.1(2017EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.2(2017EN)",
      "name" : "HCIM HealthProfessional-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-vaccination-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/Vaccination-v3.0(2016EN)",
      "name" : "HCIM Vaccination-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.0(2016EN)",
      "name" : "HCIM HealthProfessional-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-vaccination-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/Vaccination-v1.2(2015EN)",
      "name" : "HCIM Vaccination-v1.2(2015EN)"
    },
    {
      "identity" : "hcim-healthprofessional-v1.2.1-2015EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v1.2.1(2015EN)",
      "name" : "HCIM HealthProfessional-v1.2.1(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-Vaccination",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization"
      },
      {
        "id" : "Immunization.vaccineCode.coding.display",
        "path" : "Immunization.vaccineCode.coding.display",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.vaccineCode.text",
        "path" : "Immunization.vaccineCode.text",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.date",
        "path" : "Immunization.date",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.note.text",
        "path" : "Immunization.note.text",
        "mustSupport" : true
      }
    ]
  }
}

```
