# EpisodeOfCare - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EpisodeOfCare**

## Resource Profile: EpisodeOfCare 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/EpisodeOfCare | *Version*:1.22.0 |
| Draft as of 2026-01-12 | *Computable Name*:EpisodeOfCare |

 
Zorgepisode 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

N.B. ZorgEpisode komt uit de [Huisartsgegevensset](https://informatiestandaarden.nictiz.nl/wiki/MedMij:V2020.01/FHIR_GP_Data) en is een zib2020 en FHIR R4. Voor het deel dat wij gebruiken is deze volledig compatibel met zib2017 en STU3.

[ZIB ZorgEpisode](https://zibs.nl/wiki/ZorgEpisode-v1.0(2020NL))

### Request

1. Opvragen (search) zorgepisodes inclusief problemen`GET <ontsluiten-bronsysteem-base>/EpisodeOfCare?patient=<fhir_patient_id>&_include=Condition:diagnosis`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* Use this Profile: [Probleemlijst](StructureDefinition-Probleemlijst.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/EpisodeOfCare)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-EpisodeOfCare.csv), [Excel](StructureDefinition-EpisodeOfCare.xlsx), [Schematron](StructureDefinition-EpisodeOfCare.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EpisodeOfCare",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/EpisodeOfCare",
  "version" : "1.22.0",
  "name" : "EpisodeOfCare",
  "title" : "EpisodeOfCare",
  "status" : "draft",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Zorgepisode",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-concernfortransfer-v1.2-2015EN",
      "uri" : "https://zibs.nl/wiki/ConcernForTransfer-v1.2(2015EN)",
      "name" : "HCIM ConcernForTransfer-v1.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "EpisodeOfCare",
  "baseDefinition" : "http://fhir.nl/fhir/StructureDefinition/nl-core-episodeofcare",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "EpisodeOfCare",
        "path" : "EpisodeOfCare"
      },
      {
        "id" : "EpisodeOfCare.status",
        "path" : "EpisodeOfCare.status",
        "mustSupport" : true
      },
      {
        "id" : "EpisodeOfCare.diagnosis.condition",
        "path" : "EpisodeOfCare.diagnosis.condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
