# DocumentReference - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DocumentReference**

## Resource Profile: DocumentReference 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:DocumentReference |

 
Verwijzingen naar document 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### View Definition

[ViewDefinition voor Correspondentie](ViewDefinition-DocumentReference.json)

### UI Wireframe

**Correspondentie**

* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 21-8-2022
  * Beschrijving: Letter
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 21-8-2022
  * Beschrijving: Brief zorginstelling
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 22-4-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 22-4-2025
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 22-4-2025
  * Beschrijving: Letter
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 17-7-2025
  * Beschrijving: Medisch beeldvormende techniek per onderzoek
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 20-7-2025
  * Beschrijving: Poliklinische consultbrief (OK+Brief) UMCU
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 28-7-2025
  * Beschrijving: Medisch beeldvormende techniek per onderzoek
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 23-4-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 23-4-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 23-4-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 23-4-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 10-11-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 18-12-2024
  * Beschrijving: Verwijsbrief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 18-12-2024
  * Beschrijving: Radiologie
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 4-6-2025
  * Beschrijving: Blanco brief WZA
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 4-8-2025
  * Beschrijving: Blanco brief WZA
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 4-6-2025
  * Beschrijving: Blanco brief
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 68609-7
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 19-8-2025
  * Beschrijving: Ourmind .docx
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/vnd.openxmlformats-officedocument.wordprocessingml.document
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 19-8-2025
  * Beschrijving: Ourmind
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 19-8-2025
  * Beschrijving: Ourmind
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 19-8-2025
  * Beschrijving: Ourmind
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft-Bundle
  * Datum: 19-8-2025
  * Beschrijving: Ourmind
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Chipsoft
  * Datum: 11-5-2022
  * Beschrijving: test
  * Auteur: 
  * Specialisme: 394802001
  * (MimeType): application/pdf
  * (Type): 51852-2
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic-PZP
  * Datum: 23-7-2025
  * Beschrijving: Artsenbrief, Proactieve zorgplanning
  * Auteur: RPHM. Muskens, Oogarts
  * Specialisme: 
  * (MimeType): application/pdf
  * (Type): Artsenbrief
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 15-12-2021
  * Beschrijving: Patiëntenbrief, Brief (uit)
  * Auteur: G Boer
  * Specialisme: KGA - Genetica
  * (MimeType): application/pdf
  * (Type): Patiëntenbrief
* ><: 
  * Bron: 

### Kolom Definities

* MARKERING: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* MARKERING: Datum
  * ?: `iif(exists(context.period.start), context.period.start, indexed)`
  * ?: `dateTime`
  * ?: nvt
  * ?: N.B. tijd is GMT, dus omzetten naar CET.
* MARKERING: Beschrijving
  * ?: `iif(exists(description), description, content.attachment.title.replace('.pdf',''))+iif(exists(context.encounter.display),', '+context.encounter.display,'')`
  * ?: `string`
  * ?: nvt
  * ?: Tijdelijk voor Zorgplatform: gebruik`content.attachment.title`voor de beschrijving van documenten inclusief het strippen van de`.pdf`extensie
* MARKERING: Auteur
  * ?: `author.display`
  * ?: `string`
  * ?: nvt
  * ?: Tijdelijk voor Zorgplatform: indien`author.display`is gevuld met een OID, dan wordt het veld gevuld met`Auteur niet bekend`
* MARKERING: Specialisme
  * ?: `iif(context.practiceSetting.text.startsWith('2.16.840.1.113883.'), context.practiceSetting.coding.code, context.practiceSetting.text)`
  * ?: `string`
  * ?: nvt
  * ?: Tijdelijk voor Zorgplatform: indien`context.practiceSetting.text`is gevuld met een OID (startsWith('2.16.840.1.113883.)), dan wordt het veld gevuld met`context.practiceSetting.coding.code`(een SNOMED CT code)
* MARKERING: (MimeType)
  * ?: `content.attachment.contentType`
  * ?: `code`
  * ?: nvt
  * ?: Alleen`application/pdf`tonen
* MARKERING: (Type)
  * ?: `iif(type.text.startsWith('2.16.840.1.113883.'), type.coding[0].code, type.text)`
  * ?: `string`
  * ?: nvt
  * ?: 

### Document soorten herkennen

| | | |
| :--- | :--- | :--- |
| correspondenceCorrespondentie | Healthcare communication Document (56444-3) | Correspondentie, Patiëntenbrief, Verwijsbrief, Poliklinische brief, Artsenbrief |
| CS: Brief (51852-2)CS: Hospital Letter (68609-7) | CS: Brief (51852-2)CS: Hospital Letter (68609-7) | {OID?} |
| imaging-resultImaging result | Procedure note (28570-0) | Radiologie verslag |
| clinical-noteNotitie | Epic clinical-note(s) types from[DocumentReference.Search (Clinical Notes) (STU3)](https://vendorservices.epic.com/Sandbox/Index?api=865)* Discharge Documentation (18842-5)
* Consultation (11488-4)
* History & Physical (34117-2)
* Progress Note (11506-3)
* Procedure Note (28570-0)
* Emergency Department Note (34111-5)
* Nurse Note (34746-8)
* Discharge Instructions (74213-0)
* Risk assessment and screening note (75492-9)
* OR Note (11504-8)
* Miscellaneous Notes (34109-9)
 |  |

Zie het Excelbestand tab "classCode+decision tree" voor LOINC codes: [Nationale XDS metadataset](https://nictiz.nl/standaarden/overzicht-van-standaarden/xds-metadata/)

### Request

1. Opvragen (search) alle documenten`GET <ontsluiten-bronsysteem-base>/DocumentReference?patient=<fhir_patient_id>&status=current`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/DocumentReference)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentReference.csv), [Excel](StructureDefinition-DocumentReference.xlsx), [Schematron](StructureDefinition-DocumentReference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentReference",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference",
  "version" : "1.22.0",
  "name" : "DocumentReference",
  "title" : "DocumentReference",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Verwijzingen naar document",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/IHE.MHD.Minimal.DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "constraint" : [
          {
            "key" : "zv-dr-1",
            "severity" : "error",
            "human" : "Only documents with status 'current' (final documents) are expected.",
            "expression" : "status='current'",
            "xpath" : "/f:status='current'"
          }
        ]
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSetUri" : "http://fhir.hl7.nl/zorgviewer/ValueSet/DocumentLOINCCodelist"
        }
      },
      {
        "id" : "DocumentReference.class",
        "path" : "DocumentReference.class",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSetUri" : "http://fhir.hl7.nl/zorgviewer/ValueSet/DocumentLOINCCodelist"
        }
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "comment" : "Expect the references Practitioner to have his Organization",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.description",
        "path" : "DocumentReference.description",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content",
        "path" : "DocumentReference.content"
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "constraint" : [
          {
            "key" : "zv-dr-2",
            "severity" : "warning",
            "human" : "Only pdf documents are expected through the url",
            "expression" : "contentType='application/pdf'",
            "xpath" : "/f:content/f:attachement/f:contentType='application/pdf'"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "path" : "DocumentReference.content.attachment.contentType",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.url",
        "path" : "DocumentReference.content.attachment.url",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.context.period.start",
        "path" : "DocumentReference.context.period.start",
        "mustSupport" : true
      }
    ]
  }
}

```
