# AuditEvent - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AuditEvent**

## Resource Profile: AuditEvent 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent | *Version*:1.22.0 |
| Draft as of 2026-01-12 | *Computable Name*:AuditEvent |

 
AuditEvent 

* [NEN 7513:2018](https://www.nen.nl/nen-7513-2018-nl-245399) ~vrij beschikbaar na registratie~ 
* gebeurtenissen in scope van de Zorgviewer 
* Als de Zorgviewer een patient opent: "gegevens lezen"
* Als een beheerder loggegevens inziet: "loggegevens lezen"
 
 
* Zie [AuditEvent-example-1](AuditEvent-example-auditevent-zorgviewer.md)

| | | |
| :--- | :--- | :--- |
| **Gebeurtenis** |   | `AuditEvent` |
| gebeurteniscode | DCM,110110,'Patient Record' | `AuditEvent.type.coding.system = http://dicom.nema.org/resources/ontology/DCM``AuditEvent.type.coding.code = 110110``AuditEvent.type.coding.code = Patient Record` |
| actiecode | R | `AuditEvent.action = R` |
| datum en tijd | 1986‐09‐14T14:12:12 | `AuditEvent.recorded` |
| **Gebruiker** |   | `AuditEvent.agent` |
| gebruikers-id | Schroder, CP, Arts en system urn:oid:2.16.840.1.113883.2.4.3.8of AGB-Z 06020101 met system http://fhir.nl/fhir/NamingSystem/agb-z | zorgaanbieder OID`AuditEvent.agent.userId.system``AuditEvent.agent.userId.value`en`AuditEvent.agent.name` |
|   | Zelfde als voor ToestemmingConsent.policy:https://rivo-noord.nl/zorgviewer/toestemming | `AuditEvent.agent.policy` |
| gebruikersrol | 05 Directly involved healthcare professional | `AuditEvent.agent.role.coding.system``AuditEvent.agent.role.coding.code``AuditEvent.agent.role.coding.display` |
| ID van verantwoordelijke gebruiker | zie gebruikers-id |   |
| Rol van verantwoordelijke gebruiker | zie gebruikersrol |   |
| **Object** |   | `AuditEvent.entity` |
| Identificatortype | Patiëntnummer | `AuditEvent.entity.type.code = 1``AuditEvent.entity.type.system = http://hl7.org/fhir/audit-entity-type` |
| Identificator | http://fhir.nl/fhir/NamingSystem/bsn999911120 | `AuditEvent.entity.identifier.system``AuditEvent.entity.identifier.value` |
| Autorisatieprotocol | ? |   |
| Toestemmingsprofiel | ? |   |
| **Loggegevens** |   | `AuditEvent.source` |
| Identificatie van de bron | Zorgviewer RIVO-Noord | `AuditEvent.source.identifier.value` |

**NEN 7513 overzicht datamodel
geel is verplicht**

**Usages:**

* CapabilityStatements using this Profile: [Logging](CapabilityStatement-Logging.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/AuditEvent)

**Changes since version 1.21.0:**

* No changes

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AuditEvent.csv), [Excel](StructureDefinition-AuditEvent.xlsx), [Schematron](StructureDefinition-AuditEvent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AuditEvent",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AuditEvent",
  "version" : "1.22.0",
  "name" : "AuditEvent",
  "title" : "AuditEvent",
  "status" : "draft",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "AuditEvent",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "dicom",
      "uri" : "http://nema.org/dicom",
      "name" : "DICOM Tag Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/w5",
      "name" : "W5 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "fhirprovenance",
      "uri" : "http://hl7.org/fhir/provenance",
      "name" : "FHIR Provenance"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AuditEvent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AuditEvent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AuditEvent",
        "path" : "AuditEvent"
      },
      {
        "id" : "AuditEvent.type",
        "path" : "AuditEvent.type",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.action",
        "path" : "AuditEvent.action",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.recorded",
        "path" : "AuditEvent.recorded",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.agent",
        "path" : "AuditEvent.agent",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.agent.role",
        "path" : "AuditEvent.agent.role",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.agent.userId",
        "path" : "AuditEvent.agent.userId",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.agent.name",
        "path" : "AuditEvent.agent.name",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.agent.policy",
        "path" : "AuditEvent.agent.policy",
        "fixedUri" : "https://rivo-noord.nl/zorgviewer/toestemming",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.source.identifier",
        "path" : "AuditEvent.source.identifier",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.entity",
        "path" : "AuditEvent.entity",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.entity.identifier",
        "path" : "AuditEvent.entity.identifier",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.entity.type",
        "path" : "AuditEvent.entity.type",
        "mustSupport" : true
      },
      {
        "id" : "AuditEvent.entity.detail",
        "path" : "AuditEvent.entity.detail",
        "constraint" : [
          {
            "key" : "zv-ae-1",
            "severity" : "error",
            "human" : "At least 1 detail with name 'X-Request-Id' containing the associated HTTP Header value must exist.",
            "expression" : "type='X-Request-Id'",
            "xpath" : "/f:entity/f:detail[f:type='X-Request-Id']"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
