# AllergyIntolerance - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AllergyIntolerance**

## Resource Profile: AllergyIntolerance 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:AllergyIntolerance |

 
Allergie & Intolerantie 

> Dit Profiel is het resultaat van de vergelijking tussen de zib2017 FHIR Profiel en de implementaties in Epic, Chipsoft, Topicus en Nexus. De elementen die in ieder geval in alle output beschikbaar zullen zijn. Voornamelijk bedoeld voor houvast van een client en voor validatie van output.

### Zorginformatiebouwsteen

[ZIB Allergie Intolerantie](https://zibs.nl/wiki/AllergieIntolerantie-v3.2(2017NL))

### FMS Adequate Registratie

Als bron voor de must-support flags en de UI guidance is gebruikt: [Fit-gap analyse allergie-intolerantie](https://amigo.nictiz.nl/uploads/a158231f-a872-4828-b5c5-0a24e7b4e4bd/Fit_gap_analyse_Allergie-intolerantie.pdf)

### View Definition

[ViewDefinition voor Allergieën en Intoleranties](ViewDefinition-AllergyIntolerance.json)

### UI Wireframe

**Allergieen en intoleranties**

* ><: +
  * Bron: Chipsoft
  * Datum: 12-11-2019
  * Stof: ALLE NSAID'S (INCL. SALICYLATEN)
  * Toelichting: 
  * Categorie: Medicijn
  * Ernst(1): Licht
  * Ernst(2): 
  * Reacties: Huiduitslag
  * Status: active
  * StatusCS: Actief
  * (VStatus): unconfirmed
* ><: 
  * Bron: 
* ><: +
  * Bron: Epic
  * Datum: 3-12-2017
  * Stof: PINDA
  * Toelichting: 
  * Categorie: food
  * Ernst(1): 
  * Ernst(2): moderate
  * Reacties: Erythrodermie
  * Status: active
  * StatusCS: 
  * (VStatus): confirmed
* ><: 
  * Bron: 
* ><: +
  * Bron: Nexus
  * Datum: 8-11-2008
  * Stof: Bijengif
  * Toelichting: 
  * Categorie: 
  * Ernst(1): high
  * Ernst(2): severe
  * Reacties: 
  * Status: active
  * StatusCS: 
  * (VStatus): confirmed
* ><: 
  * Bron: 
* ><: +
  * Bron: Sanday
  * Datum: 6-8-2025
  * Stof: HUISSTOFMIJTENALLERGEEN
  * Toelichting: opmerking bij overgevoeligheid
  * Categorie: medication
  * Ernst(1): low
  * Ernst(2): 
  * Reacties: 
  * Status: active
  * StatusCS: 
  * (VStatus): confirmed
* ><: 
  * Bron: 
* ><: +
  * Bron: EPS
  * Datum: 9-8-1977
  * Stof: Allergy to substance
  * Toelichting: 
  * Categorie: environment
  * Ernst(1): 
  * Ernst(2): 
  * Reacties: 
  * Status: undefined
  * StatusCS: 
  * (VStatus): undefined
* ><: 
  * Bron: 
* ><: +
  * Bron: EPS
  * Datum: 9-8-1977
  * Stof: Shellfish
  * Toelichting: 
  * Categorie: food
  * Ernst(1): 
  * Ernst(2): severe
  * Reacties: 
  * Status: undefined
  * StatusCS: 
  * (VStatus): undefined
* ><: 
  * Bron: 

### Kolom Definities

* MARKERING: Bron
  * ?: `meta.extension('http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source').valueUri`
  * ?: `string`
  * ?: nvt
  * ?: Lookup adhv uri (AGB-Z of OID)`<adressering-base>/Organization?identifier=<.meta.tag.code>`en gebruik dan`Organization.name`
* MARKERING: Datum
  * ?: `onsetPeriod.start | onsetDateTime`
  * ?: `dateTime`
  * ?: StartDateTime
  * ?: 
* MARKERING: Stof
  * ?: `code.text | code.coding[0].display`
  * ?: `string`
  * ?: CausativeAgent
  * ?: 
* MARKERING: Toelichting
  * ?: `note.text`
  * ?: `string`
  * ?: Comment
  * ?: 
* MARKERING: Categorie
  * ?: `category.extension('http://nictiz.nl/fhir/StructureDefinition/code-specification').valueCodeableConcept.text | category.join(',')`
  * ?: `code`
  * ?: nvt
  * ?: Meerdere opties die tegelijk getoond kunnen worden
* MARKERING: Ernst(1)
  * ?: `criticality.extension('http://nictiz.nl/fhir/StructureDefinition/code-specification').valueCodeableConcept.text | criticality`
  * ?: `code`
  * ?: MateVanKritiek
  * ?: 
* MARKERING: Ernst(2)
  * ?: `reaction[0].severity`
  * ?: `code`
  * ?: Reactie/Ernst
  * ?: 
* MARKERING: Reacties
  * ?: `reaction[0].manifestation[0].text`
  * ?: `string`
  * ?: Reactie/Symptoom
  * ?: 
* MARKERING: Status
  * ?: `clinicalStatus`
  * ?: `code`
  * ?: AllergieStatus
  * ?: `Actief`,`Niet meer aanwezig`,`Achterhaald`en`Foutief`status wordt niet getoond in de Zorgviewer (wordt uitgefilterd). Indien geen extensie aanwezig, dan worden de waarden als volgt gemapped:`active`->`Actief`;`inactive`->`Achterhaald`;`resolved`->`Niet meer aanwezig`
* MARKERING: StatusCS
  * ?: `clinicalStatus.extension('http://nictiz.nl/fhir/StructureDefinition/code-specification').valueCodeableConcept.text`
  * ?: `code`
  * ?: AllergieStatus
  * ?: Zie Status
* MARKERING: (VStatus)
  * ?: `verificationStatus`
  * ?: `code`
  * ?: AllergieStatus
  * ?: 

### Request

1. Opvragen (search) allergieen en intoleranties`GET <ontsluiten-bronsysteem-base>/AllergyIntolerance/?patient=<fhir_patient_id>`
1. **Sanday:**Opvragen (search) allergieen en intoleranties, alleen medicatie categorie`GET <ontsluiten-bronsysteem-base>/AllergyIntolerance/?patient=<fhir_patient_id>&category=medication`

### Bronsysteem herkennen

De **Zorgviewer-backend** of **Ontsluiten bronsysteem** **MOET** na bevragen van het bronsysteem aan elk resultaat resource een meta-tag toevoegen met de AGB, OID of URA identifier van de zorgaanbieder (zie [Organization](StructureDefinition-Organization.md) voor voorbeelden). Dit wordt vervolgens gebruikt in de "Bron" kolom in de Zorgviewer-frontend. N.B. We gebruiken hier een **pre-adopt** van de FHIR R4 [Meta.source](StructureDefinition-extension-Meta.source.md).

Toevoegen aan elke response, dus per resource (bij een read) of per Bundle (bij een search):

```
"meta": {
    "extension": [ {
        "url": "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri": "urn:oid:2.16.840.1.113883.2.4.3.8"
    } ]
}

```

**Alternatief:** Elke entry van een search response Bundle bevat een referentie naar de bijbehorende Patient (`<resource>.subject|patient`). Elke patient heeft een `Patient.managingOrganization` en in de gerefereerde `Organization.identifier` staat vervolgens o.a. de OID van het bronsysyeem. Of je gebruikt de identifiers om een volledige Organization op te zoeken in het [adresboek](zorgviewer-services.md#adressering) en zie inhoud [hier](artifacts.md#zorgviewer-services-content).

**Usages:**

* CapabilityStatements using this Profile: [Ontsluiten Bronsysteem - Sanday](CapabilityStatement-OntsluitenBronsysteem-Sanday.md) and [Ontsluiten Bronsysteem](CapabilityStatement-OntsluitenBronsysteem.md)
* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.zorgviewer|current/StructureDefinition/AllergyIntolerance)

**Changes since version 1.21.0:**

* New Content

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AllergyIntolerance.csv), [Excel](StructureDefinition-AllergyIntolerance.xlsx), [Schematron](StructureDefinition-AllergyIntolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AllergyIntolerance",
  "url" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance",
  "version" : "1.22.0",
  "name" : "AllergyIntolerance",
  "title" : "AllergyIntolerance",
  "status" : "active",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Allergie & Intolerantie",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "fhirVersion" : "3.0.2",
  "mapping" : [
    {
      "identity" : "hcim-allergyintolerance-v3.2-2017EN",
      "uri" : "https://zibs.nl/wiki/AllergyIntolerance-v3.2(2017EN)",
      "name" : "HCIM AllergyIntolerance-v3.2(2017EN)"
    },
    {
      "identity" : "hcim-basicelements-v1.0-2017EN",
      "uri" : "https://zibs.nl/wiki/BasicElements-v1.0(2017EN)",
      "name" : "HCIM BasicElements-v1.0(2017EN)"
    },
    {
      "identity" : "hcim-allergyintolerance-v3.0-2016EN",
      "uri" : "https://zibs.nl/wiki/AllergyIntolerance-v3.0(2016EN)",
      "name" : "HCIM AllergyIntolerance-v3.0(2016EN)"
    },
    {
      "identity" : "hcim-allergyintolerance-v1.0.2-2015EN",
      "uri" : "https://zibs.nl/wiki/AllergyIntolerance-v1.0.2(2015EN)",
      "name" : "HCIM AllergyIntolerance-v1.0.2(2015EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "path" : "AllergyIntolerance.clinicalStatus",
        "comment" : "Zie voor mappings [AllergieStatusCodelijst-to-allergy-status](https://simplifier.net/packages/nictiz.fhir.nl.stu3.zib2017/2.2.18/files/2316940)",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code.coding.display",
        "path" : "AllergyIntolerance.code.coding.display",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.code.text",
        "path" : "AllergyIntolerance.code.text",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.onset[x]",
        "path" : "AllergyIntolerance.onset[x]",
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.onsetDateTime",
        "path" : "AllergyIntolerance.onsetDateTime",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.onsetPeriod",
        "path" : "AllergyIntolerance.onsetPeriod",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.note",
        "path" : "AllergyIntolerance.note",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.note.text",
        "path" : "AllergyIntolerance.note.text",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation.text",
        "path" : "AllergyIntolerance.reaction.manifestation.text",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.severity",
        "path" : "AllergyIntolerance.reaction.severity",
        "mustSupport" : true
      }
    ]
  }
}

```
