# Epic Procedure (Surgical History) Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic Procedure (Surgical History) Example**

## Example Procedure: Epic Procedure (Surgical History) Example

Profile: [HCIM Procedure](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-Procedure)

**status**: Completed

**notDone**: false

**category**: Surgical History

**code**: SELECTIEVE FASCIECTOMIE

**subject**: [Fictief, Jan](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/PRD-OAUTH2/api/FHIR/STU3/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3)

**performed**: 2001 --> 2001



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "VPwS1rhM16bYvo-c52ce7kwRKeEaUOJaDIeHsOSNJzFTQLcTN5Lcg7N50uR5v1Z4",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Procedure"]
  },
  "status" : "completed",
  "notDone" : false,
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "387713003",
        "display" : "Surgical procedure"
      }
    ],
    "text" : "Surgical History"
  },
  "code" : {
    "text" : "SELECTIEVE FASCIECTOMIE"
  },
  "subject" : {
    "reference" : "https:///example.org/PRD-OAUTH2/api/FHIR/STU3/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3",
    "display" : "Fictief, Jan"
  },
  "performedPeriod" : {
    "start" : "2001",
    "end" : "2001"
  }
}

```
