# PlanDefinition BgZ 2017 - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlanDefinition BgZ 2017**

## PlanDefinition: PlanDefinition BgZ 2017 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/PlanDefinition/BgZ2017 | *Version*:1.22.0 |
| Draft as of 2026-01-12 | *Computable Name*:BgZ2017 |

In deze PlanDefinition is de BgZ 2017 als DataRequirements beschreven. Deze kunnen worden gebruikt om requests met de juiste filters samen te stellen. Bijvoorbeeld voor DrugUse (DrugsGebruik) vind je hierin de juiste code value voor het opvragen van de DrugUse Observations.

**Exception generating Narrative: unexpected non-end of element null::a at line 103 column 50**



## Resource Content

```json
{
  "resourceType" : "PlanDefinition",
  "id" : "BgZ2017",
  "url" : "http://fhir.hl7.nl/zorgviewer/PlanDefinition/BgZ2017",
  "version" : "1.22.0",
  "name" : "BgZ2017",
  "title" : "BgZ 2017",
  "status" : "draft",
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "usage" : "Deze PlanDefinition bevat de (data) definitie van de BgZ 2017. Dit is de basis view voor alle zorgverleners.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "relatedArtifact" : [
    {
      "type" : "documentation",
      "url" : "https://informatiestandaarden.nictiz.nl/wiki/MedMij:V2020.01/FHIR_BGZ_2017",
      "document" : {
        "url" : "https://informatiestandaarden.nictiz.nl/wiki/MedMij:V2020.01/FHIR_BGZ_2017"
      }
    }
  ],
  "action" : [
    {
      "label" : "Raadplegen BgZ zibs en Correspondentie",
      "triggerDefinition" : [
        {
          "type" : "named-event",
          "eventName" : "Raadplegen BgZ zibs"
        }
      ],
      "output" : [
        {
          "type" : "Patient",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient",
            "http://fhir.nl/fhir/StructureDefinition/nl-core-patient"
          ]
        },
        {
          "type" : "DocumentReference",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference",
            "http://nictiz.nl/fhir/StructureDefinition/IHE.MHD.Minimal.DocumentReference"
          ]
        },
        {
          "type" : "Condition",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition",
            "http://nictiz.nl/fhir/StructureDefinition/zib-Problem"
          ],
          "codeFilter" : [
            {
              "path" : "clinicalStatus",
              "valueCoding" : [
                {
                  "code" : "active"
                },
                {
                  "code" : "resolved"
                }
              ]
            }
          ]
        },
        {
          "type" : "Procedure",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure",
            "http://nictiz.nl/fhir/StructureDefinition/zib-Verrichting"
          ]
        },
        {
          "type" : "Consent",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective",
            "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective"
          ]
        },
        {
          "type" : "Consent",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective",
            "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective"
          ]
        },
        {
          "type" : "Flag",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag",
            "http://nictiz.nl/fhir/StructureDefinition/zib-Alert"
          ]
        },
        {
          "type" : "AllergyIntolerance",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance",
            "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance"
          ]
        },
        {
          "type" : "Observation",
          "profile" : [
            "http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult",
            "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult"
          ]
        }
      ]
    }
  ]
}

```
