# Epic Patient Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic Patient Example**

## Example Patient: Epic Patient Example

Profiles: [nl-core-patient](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://fhir.nl/fhir/StructureDefinition/nl-core-patient), [proficiency](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://nictiz.nl/fhir/StructureDefinition/patient-proficiency)

Johan XXX-Helleman Male, DoB: 1964-07-25 ( https://open.epic.com/FHIR/StructureDefinition/PayerMemberId#12345678 (use: usual, ))

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Deceased: | false |
| Marital Status: | Gehuwd | | |
| Other Ids: | * Burgerservicenummer (BSN)/999911120 (use: usual, )
* EPIC/E6488 (use: usual, )
* EXTERNAL/Z6505 (use: usual, )
* FHIR/ThaUv9zZwVynLmB9U4Hcn6At8IpBc52cm1EvMXyShGhEB (use: usual, )
* FHIR STU3/eXxP1o8ZlOz21F6HXS9puLA3 (use: usual, )
* INTERNAL/ Z6505 (use: usual, )
* MYCHARTLOGIN/JHELLEMAN (use: usual, )
* UMCG/2117507 (use: usual, )
* WPRINTERNAL/745 (use: usual, )
 | | |
| Alt. Name: | J. XXX-Helleman(Official) | | |
| Contact Detail | * ph: 06 12 34 56 78(Mobile)
* [helleman@hotmail.com](mailto:helleman@hotmail.com)
* null STITSWERD 9999 XA NLD (home)
 | | |
| Wife: | * J.P.M. van Putten-XXX-helleman
* null Stitswerd 9999 XA NLD (home)
* ph: 06 12 34 56 78(Mobile)
* [xxx_helleman@hotmail.com](mailto:xxx_helleman@hotmail.com)
 | | |
| Links: | * General Practitioner: [VASTE. Huisarts 1, Longarts](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/Practitioner/emuT1pBzFZOBnEqKVG9qEYw3)
* Managing Organization: [UMCG](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/Organization/eDVBi8yhfh8A5aXnbOf6FJQ3)
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "eXxP1o8ZlOz21F6HXS9puLA3",
  "meta" : {
    "profile" : [
      "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
      "http://nictiz.nl/fhir/StructureDefinition/patient-proficiency"
    ]
  },
  "extension" : [
    {
      "url" : "http://open.epic.com/FHIR/StructureDefinition/extension/legal-sex",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.10.698084.130.657370.444039",
            "code" : "male",
            "display" : "male"
          }
        ]
      }
    },
    {
      "url" : "http://open.epic.com/FHIR/StructureDefinition/extension/sex-for-clinical-use",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.10.698084.130.657370.444039",
            "code" : "male",
            "display" : "male"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/rendered-value",
          "valueString" : "999911120"
        }
      ],
      "use" : "usual",
      "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
      "value" : "999911120"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "EPIC"
      },
      "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.5.737384.0",
      "value" : "E6488"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "EXTERNAL"
      },
      "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.2.698084",
      "value" : "Z6505"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "FHIR"
      },
      "system" : "http://open.epic.com/FHIR/StructureDefinition/patient-dstu2-fhir-id",
      "value" : "ThaUv9zZwVynLmB9U4Hcn6At8IpBc52cm1EvMXyShGhEB"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "FHIR STU3"
      },
      "system" : "http://open.epic.com/FHIR/StructureDefinition/patient-fhir-id",
      "value" : "eXxP1o8ZlOz21F6HXS9puLA3"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "INTERNAL"
      },
      "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.2.698084",
      "value" : "     Z6505"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "MYCHARTLOGIN"
      },
      "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.3.878082.110",
      "value" : "JHELLEMAN"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "UMCG"
      },
      "system" : "urn:oid:2.16.840.1.113883.2.4.3.8.12",
      "value" : "2117507"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "WPRINTERNAL"
      },
      "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.2.878082",
      "value" : "745"
    },
    {
      "use" : "usual",
      "system" : "https://open.epic.com/FHIR/StructureDefinition/PayerMemberId",
      "value" : "12345678"
    }
  ],
  "active" : true,
  "name" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
          "valueCode" : "NL1"
        }
      ],
      "use" : "official",
      "text" : "J. XXX-Helleman",
      "family" : "XXX-Helleman",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "XXX-Helleman"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-name",
            "valueString" : "Putten"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix",
            "valueString" : "van"
          }
        ]
      },
      "given" : ["Johan", "J."]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
          "valueCode" : "NL1"
        }
      ],
      "use" : "usual",
      "text" : "Johan XXX-Helleman",
      "family" : "XXX-Helleman",
      "_family" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
            "valueString" : "XXX-Helleman"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-name",
            "valueString" : "Putten"
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix",
            "valueString" : "van"
          }
        ]
      },
      "given" : ["Johan", "J."]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "06 12 34 56 78",
      "use" : "mobile"
    },
    {
      "system" : "email",
      "value" : "helleman@hotmail.com"
    }
  ],
  "gender" : "male",
  "birthDate" : "1964-07-25",
  "deceasedBoolean" : false,
  "address" : [
    {
      "use" : "home",
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "KNOLWG"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "1000"
            }
          ]
        }
      ],
      "city" : "STITSWERD",
      "postalCode" : "9999 XA",
      "country" : "NLD"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/v3/MaritalStatus",
        "code" : "M",
        "display" : "Married"
      }
    ],
    "text" : "Gehuwd"
  },
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/v3/RoleCode",
              "code" : "WIFE",
              "display" : "Wife"
            }
          ]
        }
      ],
      "name" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order",
            "valueCode" : "NL4"
          }
        ],
        "use" : "usual",
        "text" : "J.P.M. van Putten-XXX-helleman",
        "family" : "Putten van-XXX-helleman",
        "_family" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-name",
              "valueString" : "Putten"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix",
              "valueString" : "van"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/humanname-partner-name",
              "valueString" : "XXX-helleman"
            }
          ]
        },
        "given" : ["Jannie", "J.P.M."]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "06 12 34 56 78",
          "use" : "mobile"
        },
        {
          "system" : "email",
          "value" : "xxx_helleman@hotmail.com"
        }
      ],
      "address" : {
        "use" : "home",
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Knolweg"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "1000"
              }
            ]
          }
        ],
        "city" : "Stitswerd",
        "postalCode" : "9999 XA",
        "country" : "NLD"
      }
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/Practitioner/emuT1pBzFZOBnEqKVG9qEYw3",
      "display" : "VASTE. Huisarts 1, Longarts"
    }
  ],
  "managingOrganization" : {
    "reference" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/Organization/eDVBi8yhfh8A5aXnbOf6FJQ3",
    "display" : "UMCG"
  }
}

```
