# Epic VitalSign Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic VitalSign Example**

## Example Observation: Epic VitalSign Example

**com/FHIR/STU3/StructureDefinition/temperature-in-fahrenheit**: 100.4 [degF](Details: UCUM code[degF] = '[degF]')

**status**: Final

**category**: Vital Signs

**code**: Temperatuur

**subject**: [Fictief, Jan](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3)

**context**: [Ziekenhuiscontact](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Encounter/ewMH-ARQzaUMtiBbc5YVHow3)

**effective**: 2019-08-23 07:00:00+0000

**issued**: 2019-08-23 07:41:25+0000

**performer**: [S Brouwer](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Practitioner/eYJuPBBhS9otvxQbkFE8646jLy.CPbUxwb6c2B.7WGZI3)

**value**: 38 Cel(Details: UCUM codeCel = 'Cel')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "fAJm9U4NmonFyK656Yp6SRakMJ2FBBPqYFHzRYVFMdkg4",
  "extension" : [
    {
      "url" : "http://open.epic.com/FHIR/STU3/StructureDefinition/temperature-in-fahrenheit",
      "valueQuantity" : {
        "value" : 100.4,
        "unit" : "[degF]",
        "system" : "http://unitsofmeasure.org",
        "code" : "[degF]"
      }
    }
  ],
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8310-5",
        "display" : "Body temperature"
      },
      {
        "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.2.707679",
        "code" : "6",
        "display" : "Temperatuur"
      },
      {
        "system" : "http://open.epic.com/FHIR/STU3/StructureDefinition/observation-flowsheet-id",
        "code" : "tEliVs0b4qKMh8Edol1.4Mg0",
        "display" : "Temperatuur"
      },
      {
        "system" : "urn:oid:1.2.246.537.6.96",
        "code" : "8310-5"
      },
      {
        "system" : "http://loinc.org",
        "code" : "8716-3",
        "display" : "Vital signs"
      }
    ],
    "text" : "Temperatuur"
  },
  "subject" : {
    "reference" : "https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Patient/e52TXUJRLVxP2kvdXvNgS7euM1.HY8bVBMNNhsLwftTo3",
    "display" : "Fictief, Jan"
  },
  "context" : {
    "reference" : "https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Encounter/ewMH-ARQzaUMtiBbc5YVHow3",
    "display" : "Ziekenhuiscontact"
  },
  "effectiveDateTime" : "2019-08-23T07:00:00Z",
  "issued" : "2019-08-23T07:41:25Z",
  "performer" : [
    {
      "reference" : "https://icf.prd.epd.umcg.intra/PRD-OAUTH2/api/FHIR/STU3/Practitioner/eYJuPBBhS9otvxQbkFE8646jLy.CPbUxwb6c2B.7WGZI3",
      "display" : "S Brouwer"
    }
  ],
  "valueQuantity" : {
    "value" : 38,
    "unit" : "Cel",
    "system" : "http://unitsofmeasure.org",
    "code" : "Cel"
  }
}

```
