# Nexus MedicationRequest Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nexus MedicationRequest Example**

## Example MedicationRequest: Nexus MedicationRequest Example

* Medication: Authored
  * GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML: 10:39:07, 3 October 2023
* Medication: Use Duration
  * GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML: FromNoTo 10:38:00, 3 October 2023
* Medication: Dosage Instruction
  * GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML: Sequence: 1Timing:, once per ucum-d08:00:00Route Of Administration:INTRAVENEUSdoseQuantity: 1.0 ml



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "MedicationRequest-Nexus",
  "meta" : {
    "lastUpdated" : "2024-04-17T12:00:48.873+02:00",
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationAgreement"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-Medication-PeriodOfUse",
      "valuePeriod" : {
        "start" : "2023-10-03T10:38:00+02:00"
      }
    }
  ],
  "medicationReference" : {
    "reference" : "Medication/3899cd0a-ee84-4484-af9b-43ede45ecee6",
    "display" : "GLYCEROFOSFORZ. INFCONC 1MMOL/ML(FOSFAAT) AMP 20ML"
  },
  "subject" : {
    "reference" : "Patient/2214799",
    "display" : "2214799"
  },
  "authoredOn" : "2023-10-03T10:39:07+02:00",
  "requester" : {
    "agent" : {
      "reference" : "Practitioner/719",
      "display" : "Aalders, JCA (CAR)"
    }
  },
  "dosageInstruction" : [
    {
      "sequence" : 1,
      "timing" : {
        "repeat" : {
          "boundsDuration" : {
            "system" : "http://unitsofmeasure.org"
          },
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00"]
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.4.9",
            "code" : "5",
            "display" : "INTRAVENEUS"
          }
        ]
      },
      "doseQuantity" : {
        "value" : 1.0,
        "unit" : "ml",
        "system" : "urn:oid:2.16.840.1.113883.2.4.4.1.900.2",
        "code" : "233"
      }
    }
  ]
}

```
