# Epic Medication Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic Medication Example**

## Example Medication: Epic Medication Example

Profile: [HCIM PharmaceuticalProduct](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-Product)

**code**: metoPROLOL 50mg tablet

**isBrand**: false

**isOverTheCounter**: false

**form**: tablet

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Amount** |
| * | metoPROLOL 50mg tablet | 50 MG(Details: UCUM codemg = 'mg')/50 MG(Details: UCUM codemg = 'mg') |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "fHER-7BKK9hfH62XmqNj5a68SZ5WRjfaiTJvXJfeJM1s4",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Product"]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://www.whocc.no/atc",
        "code" : "C07AB02"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.4.1",
        "code" : "10642"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.4.10",
        "code" : "3158"
      },
      {
        "system" : "urn:oid:2.16.840.1.113883.2.4.4.7",
        "code" : "1169246"
      }
    ],
    "text" : "metoPROLOL 50mg tablet"
  },
  "isBrand" : false,
  "isOverTheCounter" : false,
  "form" : {
    "coding" : [
      {
        "system" : "urn:oid:1.2.840.114350.1.13.485.2.7.4.698288.310",
        "code" : "TABLET",
        "display" : "tablet"
      }
    ],
    "text" : "tablet"
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://www.whocc.no/atc",
            "code" : "C07AB02"
          },
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.4.1",
            "code" : "10642"
          },
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.4.10",
            "code" : "3158"
          },
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.4.7",
            "code" : "1169246"
          }
        ],
        "text" : "metoPROLOL 50mg tablet"
      },
      "amount" : {
        "numerator" : {
          "value" : 50,
          "unit" : "MG",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 50,
          "unit" : "MG",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        }
      }
    }
  ]
}

```
