# Chipsoft DocumentReference Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft DocumentReference Example**

## Example DocumentReference: Chipsoft DocumentReference Example

### DocumentReference resource:

* **Title** 'test.pdf'
* **EntryUUID:** 'urn:uuid:22aa9e3e-f72f-4f76-97c7-0f66c8f691f5'
* **Document location:** 'Binary/22aa9e3e-f72f-4f76-97c7-0f66c8f691f5'
* **Mimetype:** 'application/pdf'
* **Availability status:** 'urn:oasis:names:tc:ebxml-regrep:StatusType:Approved'
* **Document type:** '2.16.840.1.113883.6.1'
* **Document class:** '2.16.840.1.113883.6.1'
* **Creation date/time:** '5/11/2022 10:00:00 PM'
* **Document size (in bytes):** '85244'
* **Document language:** 'Dutch (Netherlands)'
* **Document practice setting:** '2.16.840.1.113883.2.4.3.124.8.40.1'
* **Document source healthcare facility type:** '2.16.840.1.113883.2.4.15.1060'
* **Document confidentiality:** '2.16.840.1.113883.5.25'
* **Document format:** '1.3.6.1.4.1.19376.1.2.3'
* **Document service start time:** '5/11/2022 10:00:00 PM'
* **Document service stop time:** '5/11/2022 10:00:00 PM'
* 

| |
| :--- |
|  |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "22aa9e3e-f72f-4f76-97c7-0f66c8f691f5",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/IHE.MHD.Minimal.DocumentReference"
    ]
  },
  "masterIdentifier" : {
    "system" : "http://hl7.org/fhir/StructureDefinition/uuid",
    "value" : "urn:uuid:22aa9e3e-f72f-4f76-97c7-0f66c8f691f5"
  },
  "identifier" : [
    {
      "use" : "official",
      "system" : "http://hl7.org/fhir/StructureDefinition/uuid",
      "value" : "urn:uuid:22aa9e3e-f72f-4f76-97c7-0f66c8f691f5"
    }
  ],
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51852-2",
        "display" : "2.16.840.1.113883.6.1"
      }
    ],
    "text" : "2.16.840.1.113883.6.1"
  },
  "class" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "51852-2",
        "display" : "2.16.840.1.113883.6.1"
      }
    ],
    "text" : "2.16.840.1.113883.6.1"
  },
  "indexed" : "2022-05-11T22:00:00+00:00",
  "securityLabel" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
          "code" : "R",
          "display" : "2.16.840.1.113883.5.25"
        }
      ],
      "text" : "2.16.840.1.113883.5.25"
    }
  ],
  "content" : [
    {
      "attachment" : {
        "contentType" : "application/pdf",
        "language" : "nl-NL",
        "url" : "Binary/22aa9e3e-f72f-4f76-97c7-0f66c8f691f5",
        "size" : 85244,
        "title" : "test.pdf"
      },
      "format" : {
        "system" : "http://ihe.net/fhir/ValueSet/IHE.FormatCode.codesystem",
        "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
        "display" : "1.3.6.1.4.1.19376.1.2.3"
      }
    }
  ],
  "context" : {
    "period" : {
      "start" : "2022-05-11T22:00:00+00:00",
      "end" : "2022-05-11T22:00:00+00:00"
    },
    "facilityType" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "V4",
          "display" : "2.16.840.1.113883.2.4.15.1060"
        }
      ],
      "text" : "2.16.840.1.113883.2.4.15.1060"
    },
    "practiceSetting" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "394802001",
          "display" : "2.16.840.1.113883.2.4.3.124.8.40.1"
        }
      ],
      "text" : "2.16.840.1.113883.2.4.3.124.8.40.1"
    }
  }
}

```
