# Epic AdvanceDirective Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic AdvanceDirective Example**

## Example Consent: Epic AdvanceDirective Example

Profile: [HCIM AdvanceDirective](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective)

**Comment**: Definitieve versie handreiking rechtmatigheidscontroles MSZ 2014 versie 2.0.pdf

**identifier**: `urn:oid:1.2.840.114350.1.13.485.3.7.2.686783`/9266 (use: usual, )

**status**: Active

**category**: Wilsverklaring, Niet reanimeren verklaring

**patient**: [Fictief, Henk, de](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eAhf53yRoKWiNr8l5C8hqtA3)

**dateTime**: 2021-10-12 10:55:32+0000

**consentingParty**: [Fictief, Henk, de](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eAhf53yRoKWiNr8l5C8hqtA3)

### Policies

| | |
| :--- | :--- |
| - | **Extension** |
| * |  |



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "eCSfaTk2.C2TeVxgQk.zOgw3",
  "meta" : {
    "profile" : [
      "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/Comment",
      "valueString" : "Definitieve versie handreiking rechtmatigheidscontroles MSZ 2014 versie 2.0.pdf"
    }
  ],
  "identifier" : {
    "use" : "usual",
    "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.2.686783",
    "value" : "9266"
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:1.2.840.114350.1.13.485.3.7.4.686783.100",
          "code" : "10",
          "display" : "Wilsverklaring"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "11341000146107"
        }
      ],
      "text" : "Wilsverklaring"
    },
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.60.40.4.14.1",
          "code" : "NR",
          "display" : "Niet reanimeren verklaring"
        }
      ],
      "text" : "Niet reanimeren verklaring"
    }
  ],
  "patient" : {
    "reference" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eAhf53yRoKWiNr8l5C8hqtA3",
    "display" : "Fictief, Henk, de"
  },
  "dateTime" : "2021-10-12T10:55:32Z",
  "consentingParty" : [
    {
      "reference" : "https:///example.org/TST-OAUTH2/api/FHIR/STU3/Patient/eAhf53yRoKWiNr8l5C8hqtA3",
      "display" : "Fictief, Henk, de"
    }
  ],
  "policy" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
          "valueCode" : "unknown"
        }
      ]
    }
  ]
}

```
