# Topicus TreatmentDirective Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Topicus TreatmentDirective Example**

## Example Consent: Topicus TreatmentDirective Example

Profile: [TreatmentDirective](StructureDefinition-TreatmentDirective.md)

**Comment**: Reanimatie wel (Y)

**HCIM TreatmentDirective Treatment**: cardiopulmonale resuscitatie

**HCIM TreatmentDirective TreatmentPermitted**: Ja

**status**: Active

**category**: Treatment instructions

**patient**: [Johan Helleman](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1)

**period**: 2023-10-03 14:56:05+0200 --> (ongoing)

**policyRule**: [http://wetten.overheid.nl/](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=http://wetten.overheid.nl/)



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "190c12af-49d4-4553-8009-c816ab622a3e",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/4.0/StructureDefinition/extension-Meta.source",
        "valueUri" : "uri:oid:2.16.840.1.113883.2.4.3.164.2.1.2"
      }
    ],
    "profile" : [
      "http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective"
    ]
  },
  "extension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/Comment",
      "valueString" : "Reanimatie wel (Y)"
    },
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-Treatment",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "89666000",
            "display" : "cardiopulmonale resuscitatie"
          }
        ]
      }
    }
  ],
  "modifierExtension" : [
    {
      "url" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective-TreatmentPermitted",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.2.4.3.11.60.40.4",
            "code" : "JA",
            "display" : "Ja"
          }
        ]
      }
    }
  ],
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11291000146105",
          "display" : "Treatment instructions"
        },
        {
          "system" : "http://terminology.hl7.org/CodeSystem/consentcategorycodes",
          "code" : "acd",
          "display" : "Advance Directive"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "http://example.org/Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1",
    "display" : "Johan Helleman"
  },
  "period" : {
    "start" : "2023-10-03T14:56:05+02:00"
  },
  "policyRule" : "http://wetten.overheid.nl/"
}

```
