# Epic Condition Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Epic Condition Example**

## Example Condition: Epic Condition Example

Profile: [HCIM Problem](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.zib2017@2.3.1&canonical=http://nictiz.nl/fhir/StructureDefinition/zib-Problem)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item, interpretatie van diagnose (waarneembare entiteit)

**code**: fractuur van onderste extremiteit

**subject**: [XXX_Helleman, JOHAN](https://simplifier.net/resolve?scope=nictiz.fhir.nl.stu3.eafspraak@1.0.6&canonical=https://example.org/Interconnect-nlsandbox/api/FHIR/STU3/Patient/eCyZ.JMxPOjgW6dUlD6yicw3)

**onset**: 2012-08-16 --> 2012-08-16

**assertedDate**: 2021-08-26



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "e-ZZJzEApAU6z8DStznS9pQ3",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Problem"]
  },
  "clinicalStatus" : "active",
  "verificationStatus" : "confirmed",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/condition-category",
          "code" : "problem-list-item",
          "display" : "Problem List Item"
        }
      ],
      "text" : "Problem List Item"
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "282291009",
          "display" : "interpretatie van diagnose (waarneembare entiteit)"
        }
      ],
      "text" : "interpretatie van diagnose (waarneembare entiteit)"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-nl",
        "code" : "T12.0"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "46866001"
      }
    ],
    "text" : "fractuur van onderste extremiteit"
  },
  "subject" : {
    "reference" : "https://example.org/Interconnect-nlsandbox/api/FHIR/STU3/Patient/eCyZ.JMxPOjgW6dUlD6yicw3",
    "display" : "XXX_Helleman, JOHAN"
  },
  "onsetPeriod" : {
    "start" : "2012-08-16",
    "end" : "2012-08-16"
  },
  "assertedDate" : "2021-08-26"
}

```
