# Chipsoft Condition Example - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Chipsoft Condition Example**

## Example Condition: Chipsoft Condition Example

### Condition resource:

* **Subject:** 'Johan XXX_Helleman_Afblijven'
* **Clinical status:** 'Active'
* **Verification status:** 'Confirmed'
* **Category:** 'Diagnosis'
* **Code:** 'Other'
* **Onset date/time:** '1-1-2001'
* **Body site:** 'Other'
* **Laterality:** 'Right'
* **Asserter:** 'Practitioner author with last name 'van Cruijningen de Winter'.'
* **Note:** 'Gevallen op kunstijsbaan.'



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "a20d2048-e1b7-467d-8bb5-28142af195d6",
  "meta" : {
    "profile" : ["http://nictiz.nl/fhir/StructureDefinition/zib-Problem"]
  },
  "clinicalStatus" : "active",
  "_clinicalStatus" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/code-specification",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "55561003",
              "display" : "Active"
            }
          ],
          "text" : "Actueel"
        }
      }
    ]
  },
  "verificationStatus" : "confirmed",
  "_verificationStatus" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/code-specification",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "410605003",
              "display" : "Confirmed"
            }
          ],
          "text" : "Confirmed"
        }
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "282291009",
          "display" : "Diagnosis"
        }
      ],
      "text" : "Diagnose"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/v3/NullFlavor",
        "code" : "OTH",
        "display" : "other"
      }
    ],
    "text" : "fractuur van pols"
  },
  "bodySite" : [
    {
      "extension" : [
        {
          "url" : "http://nictiz.nl/fhir/StructureDefinition/BodySite-Qualifier",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "24028007",
                "display" : "Right"
              }
            ],
            "text" : "Rechts"
          }
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/9819C39260647B5DE61609CDF1FA1C434552D65014AFDEA2EB877A576B055DF1",
    "display" : "Patient name: Johan XXX_Helleman_Afblijven"
  },
  "onsetDateTime" : "2001-01-01",
  "assertedDate" : "2001-01-01",
  "asserter" : {
    "extension" : [
      {
        "url" : "http://nictiz.nl/fhir/StructureDefinition/practitionerrole-reference",
        "valueReference" : {
          "reference" : "http://example.org/PractitionerRole/2FEBFCB8FFA86EBEF907D0B6CC74E210A7647FA82CEC3DE55E3FA8813D5756F6",
          "display" : "Practitioner role with function: 'attending physician'."
        }
      }
    ],
    "reference" : "http://example.org/Practitioner/ecb6593e-75fe-4b02-8a4f-25302a6f9693",
    "display" : "Practitioner with name: 'Lisette van Cruijningen de Winter'."
  },
  "note" : [
    {
      "text" : "Gevallen op kunstijsbaan."
    }
  ]
}

```
