# Sanday functies naar SNOMED-CT Mapping - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sanday functies naar SNOMED-CT Mapping**

## ConceptMap: Sanday functies naar SNOMED-CT Mapping 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/ConceptMap/sanday | *Version*:1.22.0 |
| Active as of 2026-01-12 | *Computable Name*:sanday |

 
Deze ConceptMap beschrijft de functiebenamingen die in Sanday worden gebruikt en koppelt deze aan SNOMED CT-codes. Let op: dit is een tijdelijke mapping. Sanday gebruikt momenteel functienaam-strings in plaats van gestandaardiseerde codes. De in deze mapping gebruikte codes hebben alleen betekenis binnen de context van de Zorgviewer. 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "sanday",
  "url" : "http://fhir.hl7.nl/zorgviewer/ConceptMap/sanday",
  "version" : "1.22.0",
  "name" : "sanday",
  "title" : "Sanday functies naar SNOMED-CT Mapping",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-12T14:21:48+00:00",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze ConceptMap beschrijft de functiebenamingen die in Sanday worden gebruikt en koppelt deze aan SNOMED CT-codes. Let op: dit is een tijdelijke mapping. Sanday gebruikt momenteel functienaam-strings in plaats van gestandaardiseerde codes. De in deze mapping gebruikte codes hebben alleen betekenis binnen de context van de Zorgviewer.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "Sanday",
      "sourceVersion" : "Sanday",
      "target" : "http://fhir.hl7.nl/zorgviewer/ValueSet/SubjectRoleCodelist",
      "element" : [
        {
          "code" : "1",
          "display" : "Huisarts",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "62247001",
              "display" : "huisarts",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "2",
          "display" : "Doktersassistente",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "22515006",
              "display" : "medisch assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "3",
          "display" : "Arts in opleiding (HAIO / AIOS)",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "405277009",
              "display" : "arts-assistent",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "4",
          "display" : "Doktersassistente in opleiding",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "224610007",
              "display" : "personeel voor ondersteunende diensten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "5",
          "display" : "Praktijkverpleegkundige",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "159002008",
              "display" : "praktijkverpleegkundige",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "6",
          "display" : "Administratieve medewerker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "106353008",
              "display" : "administratief medewerker",
              "equivalence" : "equal",
              "comment" : "Geen toegang"
            }
          ]
        },
        {
          "code" : "7",
          "display" : "Financiële medewerker",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "63804002",
              "display" : "financieel medewerker",
              "equivalence" : "equal",
              "comment" : "Geen toegang"
            }
          ]
        },
        {
          "code" : "8",
          "display" : "Praktijkondersteuner",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "224610007",
              "display" : "personeel voor ondersteunende diensten",
              "equivalence" : "wider"
            }
          ]
        },
        {
          "code" : "9",
          "display" : "Systeembeheerder",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "wider"
                }
              ],
              "code" : "224610007",
              "display" : "personeel voor ondersteunende diensten",
              "equivalence" : "wider",
              "comment" : "Geen toegang"
            }
          ]
        },
        {
          "code" : "10",
          "display" : "Praktijkbeheerder",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "159481007",
              "display" : "praktijkmanager",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "11",
          "display" : "Physician assistant",
          "target" : [
            {
              "modifierExtension" : [
                {
                  "url" : "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence",
                  "valueCode" : "equal"
                }
              ],
              "code" : "449161006",
              "display" : "physician assistant",
              "equivalence" : "equal"
            }
          ]
        }
      ]
    }
  ]
}

```
