# Toestemming - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Toestemming**

## CapabilityStatement: Toestemming 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Toestemming | *Version*:1.22.0 |
| Draft as of 2023-09-04 | *Computable Name*:Toestemming |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Toestemming en Adressering Bouwblok. 

 [Raw OpenAPI-Swagger Definition file](Toestemming.openapi.json) | [Download](Toestemming.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "Toestemming",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/Toestemming",
  "version" : "1.22.0",
  "name" : "Toestemming",
  "title" : "Toestemming",
  "status" : "draft",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Toestemming en Adressering Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent",
      "display" : "ToestemmingConsent"
    },
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization",
      "display" : "Organization"
    },
    {
      "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint",
      "display" : "Endpoint"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/ToestemmingConsent"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Organization",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Organization"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Endpoint",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Endpoint"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
