# Ontsluiten Bronsysteem - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ontsluiten Bronsysteem**

## CapabilityStatement: Ontsluiten Bronsysteem 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem | *Version*:1.22.0 |
| Active as of 2023-09-04 | *Computable Name*:OntsluitenBronsysteem |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft de minimale requirements voor het Ontsluiten Bronsysteem Bouwblok. 

Benodigde SMART-on-FHIR [scopes](http://hl7.org/fhir/smart-app-launch/1.0.0/scopes-and-launch-context/index.html):

1. user/Patient.search
1. user/Patient.read
1. user/DocumentReference.search
1. user/Binary.read
1. user/Condition.search
1. user/Practitioner.read
1. user/PractitionerRole.search
1. user/Procedure.search
1. user/Observation.search
1. user/Specimen.read
1. user/Consent.search
1. user/Flag.search
1. user/MedicationRequest.search
1. user/MedicationStatement.search
1. user/Immunization.search
1. user/Appointment.search
1. user/Encounter.search

 [Raw OpenAPI-Swagger Definition file](OntsluitenBronsysteem.openapi.json) | [Download](OntsluitenBronsysteem.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "OntsluitenBronsysteem",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem",
  "version" : "1.22.0",
  "name" : "OntsluitenBronsysteem",
  "title" : "Ontsluiten Bronsysteem",
  "status" : "active",
  "date" : "2023-09-04",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft de minimale requirements voor het Ontsluiten Bronsysteem Bouwblok.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "requirements",
  "fhirVersion" : "3.0.2",
  "acceptUnknown" : "both",
  "format" : ["xml", "json"],
  "profile" : [
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
      "display" : "nl-core-patient"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-organization",
      "display" : "nl-core-organization"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitioner",
      "display" : "nl-core-practitioner"
    },
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-practitionerrole",
      "display" : "nl-core-practitionerrole"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Problem",
      "display" : "zib-Probleem"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Procedure",
      "display" : "zib-Verrichting"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-AdvanceDirective",
      "display" : "zib-AdvanceDirective"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-TreatmentDirective",
      "display" : "zib-TreatmentDirective"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Alert",
      "display" : "zib-Alert"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance",
      "display" : "zib-AllergyIntolerance"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Observation",
      "display" : "zib-LaboratoryTestResult-Observation"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-LaboratoryTestResult-Specimen",
      "display" : "zib-LaboratoryTestResult-Specimen"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationAgreement",
      "display" : "zib-MedicationAgreement"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationUse",
      "display" : "zib-MedicationUse"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Vaccination",
      "display" : "zib-Vaccination"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/eAfspraak-Appointment",
      "display" : "eAfspraak-Appointment"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Encouner",
      "display" : "zib-Encouner"
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ],
            "text" : "OAuth2 using SMART-on-FHIR profile (see http://docs.smarthealthit.org)"
          }
        ]
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Patient-identifier",
              "type" : "token",
              "documentation" : "The server **SHALL** support search based on BSN, system=http://fhir.nl/fhir/NamingSystem/bsn"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Condition",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "DocumentReference",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/DocumentReference"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Binary",
          "profile" : {
            "reference" : "http://hl7.org/fhir/StructureDefinition/Binary"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Practitioner",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Practitioner"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "PractitionerRole",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/PractitionerRole"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Procedure",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AdvanceDirective"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Consent-category",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Consent",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/TreatmentDirective"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Consent-category",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Flag",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Flag"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AllergyIntolerance",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : ["Observation:specimen"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Specimen",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Specimen"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "MedicationRequest",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ],
          "searchInclude" : ["MedicationRequest:medication"]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "MedicationStatement",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationStatement"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Immunization",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Immunization"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Appointment",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Appointment"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Encounter",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Encounter"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        }
      ]
    }
  ]
}

```
