# Ontsluiten Bronsysteem - Sanday - RIVO-Noord Zorgviewer Implementation Guide v1.22.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ontsluiten Bronsysteem - Sanday**

## CapabilityStatement: Ontsluiten Bronsysteem - Sanday 

| | |
| :--- | :--- |
| *Official URL*:http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem-Sanday | *Version*:1.22.0 |
| Active as of 2025-12-24 | *Computable Name*:OntsluitenBronsysteemSanday |
| **Copyright/Legal**: CC0 | |

 
Deze CapabilityStatement beschrijft Ontsluiten Bronsysteem voor Sanday. 

### Bevragen bronsysteem: Autorisatie

In onderstaande tabel staan de benodigde attributen voor bevragen van een Sanday systeem vanuit de Zorgviewer.

| | | | |
| :--- | :--- | :--- | :--- |
| Patient BSN | **via $match** | `999911120` | Patient.identifier[system=BSN] |
| Requesting Organization (OID) | context-requester-org-id | `2.16.528.1.1007.3.3.15123` | Practitioner.meta[extension=source] |
| Target Organization (AGB) | context-target-org-id | [`01010813`](https://www.vektis.nl/agb-register/onderneming-01010813) | system=http://fhir.nl/fhir/NamingSystem/agb-z |

### Bevragen bronsysteem: Patient identificatie

1. Opzoeken patient FHIR id middels Patient/$match en de BSN van de patient
1. Meegeven patient FHIR id bij elke request als parameter "patient"

### Bevragen bronsysteem: Requests

* Niet Flag (Alerts), Immunization (Vaccinaties) en DocumentReferences (Correspondentie) uitvragen.
* Zie ook specifieke Requests voor [VitalSigns](https://build.fhir.org/ig/RIVO-Noord/zorgviewer-ig/StructureDefinition-VitalSign.html#request), [LaboratoryTestResult](StructureDefinition-LaboratoryTestResult.md#request) en [AllergyIntolerance](StructureDefinition-AllergyIntolerance.md#request).

 [Raw OpenAPI-Swagger Definition file](OntsluitenBronsysteem-Sanday.openapi.json) | [Download](OntsluitenBronsysteem-Sanday.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "OntsluitenBronsysteem-Sanday",
  "url" : "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem-Sanday",
  "version" : "1.22.0",
  "name" : "OntsluitenBronsysteemSanday",
  "title" : "Ontsluiten Bronsysteem - Sanday",
  "status" : "active",
  "date" : "2025-12-24",
  "publisher" : "RIVO-NN HL7NL",
  "contact" : [
    {
      "name" : "RIVO-NN",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://rivo-noord.nl"
        }
      ]
    },
    {
      "name" : "HL7NL",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.nl"
        }
      ]
    }
  ],
  "description" : "Deze CapabilityStatement beschrijft Ontsluiten Bronsysteem voor Sanday.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL"
        }
      ]
    }
  ],
  "copyright" : "CC0",
  "kind" : "capability",
  "instantiates" : [
    "http://fhir.hl7.nl/zorgviewer/CapabilityStatement/OntsluitenBronsysteem"
  ],
  "software" : {
    "name" : "Sanday FHIR GP Data Services",
    "version" : "1.11"
  },
  "fhirVersion" : "4.0.1",
  "acceptUnknown" : "both",
  "format" : ["json"],
  "profile" : [
    {
      "reference" : "http://fhir.nl/fhir/StructureDefinition/nl-core-patient",
      "display" : "nl-core-patient"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-Problem",
      "display" : "zib-Probleem"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-AllergyIntolerance",
      "display" : "zib-AllergyIntolerance"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-GeneralMeasurement",
      "display" : "zib-GeneralMeasurement"
    },
    {
      "reference" : "http://nictiz.nl/fhir/StructureDefinition/zib-MedicationAgreement",
      "display" : "zib-MedicationAgreement"
    }
  ],
  "rest" : [
    {
      "mode" : "client",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/restful-security-service",
                "code" : "OAuth2"
              },
              {
                "system" : "http://hl7.org/fhir/restful-security-service",
                "code" : "Certificates"
              }
            ],
            "text" : "SAML"
          }
        ]
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD-NOT"
            }
          ],
          "type" : "DocumentReference",
          "documentation" : "Documenten worden niet ontsloten naar zorgverleners.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD-NOT"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD-NOT"
            }
          ],
          "type" : "Immunization",
          "documentation" : "Vaccinaties worden niet geregistreerd.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD-NOT"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD-NOT"
            }
          ],
          "type" : "Flag",
          "documentation" : "Alerts worden gebruikt als attentieflag ipv waarschuwing voor e.g. infectiegevaar.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD-NOT"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Patient"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Condition",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Condition"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Procedure",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/Procedure"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AllergyIntolerance",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/AllergyIntolerance"
          },
          "documentation" : "Alleen medicatie allergieen.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Observation",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/LaboratoryTestResult"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "MedicationRequest",
          "profile" : {
            "reference" : "http://fhir.hl7.nl/zorgviewer/StructureDefinition/MedicationRequest"
          },
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ],
          "searchInclude" : ["MedicationRequest:medication"]
        }
      ],
      "operation" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "name" : "match",
          "definition" : {
            "reference" : "http://hl7.org/fhir/OperationDefinition/Patient-match"
          }
        }
      ]
    }
  ]
}

```
